/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventoryCapability {
    public static ICapabilityProvider createProvider(ArmorStand entity) {
        return new Provider(entity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler handler;

        private Provider(ArmorStand entity) {
            this.handler = new CurioInventoryWrapper(entity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag tag) {
            this.handler.readTag(tag);
        }
    }

    public static class CurioInventoryWrapper
    implements ICuriosItemHandler {
        Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
        NonNullList<ItemStack> invalidStacks = NonNullList.m_122779_();
        ArmorStand wearer;
        Set<ICurioStacksHandler> updates = new HashSet<ICurioStacksHandler>();

        CurioInventoryWrapper(ArmorStand entity) {
            this.wearer = entity;
            this.reset();
        }

        public void reset() {
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            if (slotHelper != null && this.wearer != null && !this.wearer.m_20193_().m_5776_()) {
                this.curios.clear();
                this.invalidStacks.clear();
                TreeSet sorted = new TreeSet(slotHelper.getSlotTypes((LivingEntity)this.wearer));
                for (ISlotType slotType : sorted) {
                    this.curios.put(slotType.getIdentifier(), (ICurioStacksHandler)new CurioStacksHandler((ICuriosItemHandler)this, slotType.getIdentifier(), slotType.getSize(), slotType.isVisible(), slotType.hasCosmetic()));
                }
            }
        }

        public int getSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        public int getVisibleSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                if (!stacks.isVisible()) continue;
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
            return Optional.ofNullable(this.curios.get(identifier));
        }

        public Map<String, ICurioStacksHandler> getCurios() {
            return Collections.unmodifiableMap(this.curios);
        }

        public void setCurios(Map<String, ICurioStacksHandler> curios) {
            this.curios = curios;
        }

        public void growSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
            }
        }

        public void shrinkSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.shrink(amount));
            }
        }

        public LivingEntity getWearer() {
            return this.wearer;
        }

        public void loseInvalidStack(ItemStack stack) {
            this.invalidStacks.add((Object)stack);
        }

        public void handleInvalidStacks() {
            if (this.wearer != null && !this.invalidStacks.isEmpty()) {
                this.invalidStacks.forEach(drop -> this.dropStack((LivingEntity)this.wearer, (ItemStack)drop));
                this.invalidStacks = NonNullList.m_122779_();
            }
        }

        public int getFortuneLevel(@Nullable LootContext lootContext) {
            return 0;
        }

        public int getLootingLevel(DamageSource source, LivingEntity target, int baseLooting) {
            return 0;
        }

        public ListTag saveInventory(boolean clear) {
            ListTag taglist = new ListTag();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                int i;
                CompoundTag tag = new CompoundTag();
                ICurioStacksHandler stacksHandler = entry.getValue();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                tag.m_128365_("Stacks", (Tag)stacks.serializeNBT());
                tag.m_128365_("Cosmetics", (Tag)cosmetics.serializeNBT());
                tag.m_128359_("Identifier", entry.getKey());
                taglist.add((Object)tag);
                if (!clear) continue;
                for (i = 0; i < stacks.getSlots(); ++i) {
                    stacks.setStackInSlot(i, ItemStack.f_41583_);
                }
                for (i = 0; i < cosmetics.getSlots(); ++i) {
                    cosmetics.setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            return taglist;
        }

        public void loadInventory(ListTag data) {
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    CompoundTag tag = data.m_128728_(i);
                    String identifier = tag.m_128461_("Identifier");
                    ICurioStacksHandler stacksHandler = this.curios.get(identifier);
                    if (stacksHandler == null) continue;
                    CompoundTag stacksData = tag.m_128469_("Stacks");
                    ItemStackHandler loaded = new ItemStackHandler();
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    if (!stacksData.m_128456_()) {
                        loaded.deserializeNBT(stacksData);
                        this.loadStacks(stacksHandler, loaded, stacks);
                    }
                    if ((stacksData = tag.m_128469_("Cosmetics")).m_128456_()) continue;
                    loaded.deserializeNBT(stacksData);
                    stacks = stacksHandler.getCosmeticStacks();
                    this.loadStacks(stacksHandler, loaded, stacks);
                }
            }
        }

        public Set<ICurioStacksHandler> getUpdatingInventories() {
            return this.updates;
        }

        public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addTransientModifier(attributeModifier);
                }
            }
        }

        public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addPermanentModifier(attributeModifier);
                }
            }
        }

        public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.removeModifier(attributeModifier.m_22209_());
                }
            }
        }

        public void clearSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearModifiers();
            }
        }

        public void clearCachedSlotModifiers() {
            HashMultimap slots = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                ICurioStacksHandler stacksHandler = entry.getValue();
                Set modifiers = stacksHandler.getCachedModifiers();
                if (modifiers.isEmpty()) continue;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                NonNullList renderStates = stacksHandler.getRenders();
                String id = entry.getKey();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    SlotContext slotContext = new SlotContext(id, this.getWearer(), i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    UUID uuid = UUID.nameUUIDFromBytes((id + i).getBytes());
                    Multimap map = CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack);
                    for (Attribute attribute : map.keySet()) {
                        if (!(attribute instanceof CuriosHelper.SlotAttributeWrapper)) continue;
                        CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)attribute;
                        slots.putAll((Object)wrapper.identifier, (Iterable)map.get((Object)attribute));
                    }
                }
            }
            for (Map.Entry<String, Object> entry : slots.asMap().entrySet()) {
                String id = entry.getKey();
                ICurioStacksHandler stacksHandler = this.curios.get(id);
                if (stacksHandler == null) continue;
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    stacksHandler.getCachedModifiers().remove(attributeModifier);
                }
                stacksHandler.clearCachedModifiers();
            }
        }

        public Multimap<String, AttributeModifier> getModifiers() {
            HashMultimap result = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                result.putAll((Object)entry.getKey(), entry.getValue().getModifiers().values());
            }
            return result;
        }

        private void loadStacks(ICurioStacksHandler stacksHandler, ItemStackHandler loaded, IDynamicStackHandler stacks) {
            for (int j = 0; j < stacksHandler.getSlots() && j < loaded.getSlots(); ++j) {
                ItemStack stack = stacks.getStackInSlot(j);
                ItemStack loadedStack = loaded.getStackInSlot(j);
                if (stack.m_41619_()) {
                    stacks.setStackInSlot(j, loadedStack);
                    continue;
                }
                this.loseInvalidStack(stack);
            }
        }

        public Tag writeTag() {
            CompoundTag result = new CompoundTag();
            ListTag slotTypes = new ListTag();
            this.getCurios().forEach((key, stacksHandler) -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("StacksHandler", (Tag)stacksHandler.serializeNBT());
                tag.m_128359_("Identifier", key);
                slotTypes.add((Object)tag);
            });
            result.m_128365_("Curios", (Tag)slotTypes);
            return result;
        }

        public void readTag(Tag tag) {
            ListTag slotTypes = ((CompoundTag)tag).m_128437_("Curios", 10);
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            if (!slotTypes.isEmpty() && slotHelper != null) {
                LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
                TreeMap<ISlotType, Object> sortedCurios = new TreeMap<ISlotType, Object>();
                TreeSet sorted = new TreeSet(CuriosApi.getSlotHelper().getSlotTypes((LivingEntity)this.wearer));
                for (ISlotType slotType2 : sorted) {
                    sortedCurios.put(slotType2, new CurioStacksHandler((ICuriosItemHandler)this, slotType2.getIdentifier(), slotType2.getSize(), slotType2.isVisible(), slotType2.hasCosmetic()));
                }
                for (int i = 0; i < slotTypes.size(); ++i) {
                    CompoundTag curioTag = slotTypes.m_128728_(i);
                    String identifier = curioTag.m_128461_("Identifier");
                    CurioStacksHandler prevStacksHandler = new CurioStacksHandler((ICuriosItemHandler)this, identifier);
                    prevStacksHandler.deserializeNBT(curioTag.m_128469_("StacksHandler"));
                    Optional optionalType = CuriosApi.getSlotHelper().getSlotType(identifier);
                    optionalType.ifPresent(type -> {
                        int slotIndex;
                        CurioStacksHandler newStacksHandler = new CurioStacksHandler((ICuriosItemHandler)this, type.getIdentifier(), type.getSize(), type.isVisible(), type.hasCosmetic());
                        newStacksHandler.copyModifiers((ICurioStacksHandler)prevStacksHandler);
                        for (slotIndex = 0; slotIndex < newStacksHandler.getSlots() && slotIndex < prevStacksHandler.getSlots(); ++slotIndex) {
                            ItemStack prevCosmetic;
                            ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(slotIndex);
                            if (!prevStack.m_41619_()) {
                                newStacksHandler.getStacks().setStackInSlot(slotIndex, prevStack);
                            }
                            if ((prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(slotIndex)).m_41619_()) continue;
                            newStacksHandler.getCosmeticStacks().setStackInSlot(slotIndex, prevStacksHandler.getCosmeticStacks().getStackInSlot(slotIndex));
                        }
                        while (slotIndex < prevStacksHandler.getSlots()) {
                            this.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(slotIndex));
                            this.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(slotIndex));
                            ++slotIndex;
                        }
                        sortedCurios.put((ISlotType)type, newStacksHandler);
                        for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                            newStacksHandler.getRenders().set(j, (Object)((Boolean)prevStacksHandler.getRenders().get(j)));
                        }
                    });
                    if (!optionalType.isEmpty()) continue;
                    IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                    for (int removedSlotIndex = 0; removedSlotIndex < stackHandler.getSlots(); ++removedSlotIndex) {
                        ItemStack cosmeticStack;
                        ItemStack stack = stackHandler.getStackInSlot(removedSlotIndex);
                        if (!stack.m_41619_()) {
                            this.loseInvalidStack(stack);
                        }
                        if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(removedSlotIndex)).m_41619_()) continue;
                        this.loseInvalidStack(cosmeticStack);
                    }
                }
                sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
                this.setCurios(curios);
            }
        }

        private void dropStack(LivingEntity entity, ItemStack stack) {
            if (!entity.f_19853_.m_5776_()) {
                ItemEntity itemEntity = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), stack);
                entity.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
    }
}

