/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.tokenenchanter.loot.function.FillXpItemFunction;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModLoot;
import net.silentchaos512.tokenenchanter.setup.Registration;

public class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(BlockLootTables::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(ChestLootTables::new, (Object)LootContextParamSets.f_81411_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    private static final class ChestLootTables
    extends ChestLoot {
        private ChestLootTables() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLoot.Injector.Tables.CHESTS_SIMPLE_DUNGEON, ChestLootTables.addXpItems());
        }

        private static LootTable.Builder addXpItems() {
            LootTable.Builder builder = LootTable.m_79147_();
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(ModItems.XP_BREAD).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_(FillXpItemFunction.builder((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(ModItems.SMALL_XP_CRYSTAL).m_79707_(5).m_79078_(FillXpItemFunction.builder((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)9.0f)))));
            return builder;
        }
    }

    private static final class BlockLootTables
    extends BlockLoot {
        private BlockLootTables() {
        }

        protected void addTables() {
            this.m_124288_((Block)ModBlocks.TOKEN_ENCHANTER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }
    }
}

