/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageItemImpl;
import net.silentchaos512.tokenenchanter.util.TextUtil;

public class XpCrystalItem
extends Item {
    private final int maxLevels;

    public XpCrystalItem(int maxLevels, Item.Properties properties) {
        super(properties);
        this.maxLevels = maxLevels;
    }

    public static int getLevels(ItemStack stack) {
        LazyOptional capability = stack.getCapability(XpStorageCapability.INSTANCE);
        if (capability.isPresent()) {
            IXpStorage xpStorage = (IXpStorage)capability.orElseThrow(IllegalStateException::new);
            return (int)xpStorage.getLevels();
        }
        return 0;
    }

    private static int getFillAmount(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        int normalAmount = xp.getCapacity() / 5;
        int freeSpace = (int)((float)xp.getCapacity() - xp.getLevels());
        return Math.min(freeSpace, normalAmount);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == XpStorageCapability.INSTANCE) {
                    return LazyOptional.of(() -> new XpStorageItemImpl(stack, XpCrystalItem.this.maxLevels, true)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public int m_142158_(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        float levels = xp.getLevels();
        float max = xp.getCapacity();
        if (max == 0.0f) {
            return 0;
        }
        return 13 - Math.round(13.0f * (max - levels) / max);
    }

    public int m_142159_(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        float levels = xp.getLevels();
        float max = xp.getCapacity();
        float f = Math.max(0.0f, 1.0f - (max - levels) / max);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 16;
    }

    private static int getPlayerLevel(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_150110_().f_35937_ ? Integer.MAX_VALUE : player.f_36078_;
        }
        return 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        int fillAmount = XpCrystalItem.getFillAmount(stack);
        if (xp.getLevels() < (float)xp.getCapacity()) {
            if (XpCrystalItem.getPlayerLevel((LivingEntity)playerIn) >= fillAmount) {
                playerIn.m_6672_(handIn);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            Component msg = TextUtil.translate("item", "xp_crystal.not_enough_levels", fillAmount);
            playerIn.m_5661_(msg, true);
            playerIn.m_36335_().m_41524_((Item)this, 10);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        int fillAmount;
        int playerLevels = XpCrystalItem.getPlayerLevel(entityLiving);
        if (playerLevels >= (fillAmount = XpCrystalItem.getFillAmount(stack)) && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            player.m_6749_(-fillAmount);
            ItemStack ret = stack.m_41777_();
            ret.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(fillAmount));
            return ret;
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        float levels = xp.getLevels();
        if (levels <= 0.1f) {
            tooltip.add((Component)TextUtil.translate("item", "xp_crystal.hint", new Object[0]).m_6879_().m_130940_(ChatFormatting.ITALIC));
        }
        String levelsFormatted = String.format("%.1f", Float.valueOf(levels));
        String max = String.valueOf(xp.getCapacity());
        tooltip.add(TextUtil.translate("item", "xp_crystal.levels", levelsFormatted, max));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            ItemStack empty = new ItemStack((ItemLike)this);
            items.add((Object)empty);
            ItemStack full = empty.m_41777_();
            full.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(xp.getCapacity()));
            items.add((Object)full);
        }
    }
}

