/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.setup;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.tokenenchanter.setup.ModBlockEntityTypes;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModContainers;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;

public class Registration {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = Registration.create(ForgeRegistries.BLOCK_ENTITY_TYPES);
    public static final DeferredRegister<Block> BLOCKS = Registration.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<Item> ITEMS = Registration.create(ForgeRegistries.ITEMS);
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS = Registration.create(Registry.f_122816_);
    public static final DeferredRegister<MenuType<?>> MENUS = Registration.create(ForgeRegistries.MENU_TYPES);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = Registration.create(ForgeRegistries.RECIPE_SERIALIZERS);
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = Registration.create(ForgeRegistries.RECIPE_TYPES);

    private Registration() {
    }

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_ENTITIES.register(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        LOOT_FUNCTIONS.register(modEventBus);
        MENUS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        ModBlockEntityTypes.register();
        ModBlocks.register();
        ModContainers.register();
        ModItems.register();
        ModRecipes.register();
    }

    private static <T> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"tokenenchanter");
    }

    private static <B> DeferredRegister<B> create(ResourceKey<Registry<B>> registry) {
        return DeferredRegister.create(registry, (String)"tokenenchanter");
    }
}

