/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.core.block.BlockWithEntityGuiTank;

public class BlockColossalBloodChest
extends BlockWithEntityGuiTank
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public BlockColossalBloodChest(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityColossalBloodChest::new);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockColossalBloodChest.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_COLOSSAL_BLOOD_CHEST, (BlockEntityTicker)(level.f_46443_ ? new BlockEntityColossalBloodChest.TickerClient() : new BlockEntityColossalBloodChest.TickerServer()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.m_7514_(blockState);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            if (!BlockEntityColossalBloodChest.canWork(world, blockPos)) {
                return InteractionResult.FAIL;
            }
            return super.m_6227_(blockState, world, blockPos, player, hand, rayTraceResult);
        }
        BlockColossalBloodChest.addPlayerChatError(world, blockPos, player, hand);
        return InteractionResult.FAIL;
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    public static void triggerDetector(LevelReader world, BlockPos blockPos, boolean valid) {
        BlockEntityColossalBloodChest.getCubeDetector().detect(world, blockPos, valid ? null : blockPos, true);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntityColossalBloodChest tile;
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41788_() && (tile = (BlockEntityColossalBloodChest)BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityColossalBloodChest.class).orElse(null)) != null) {
            tile.setSize(Vec3i.f_123288_);
        }
        BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, true);
    }

    public void m_6807_(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.m_6807_(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.m_60734_() != blockStateOld.m_60734_() && !((Boolean)blockStateNew.m_61143_((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, blockPos, true);
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, blockPos, false);
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, false);
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.m_7592_(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.m_8055_(location).m_60734_();
        if (block == this) {
            ((Level)world).m_7731_(location, (BlockState)world.m_8055_(location).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)location, BlockEntityColossalBloodChest.class).ifPresent(tile -> {
                tile.setSize(valid ? size : Vec3i.f_123288_);
                tile.setCenter(originCorner.m_142082_(1, 1, 1));
            });
        }
    }

    public static void addPlayerChatError(Level world, BlockPos blockPos, Player player, InteractionHand hand) {
        if (!world.f_46443_ && player.m_21120_(hand).m_41619_()) {
            DetectionResult result = BlockEntityColossalBloodChest.getCubeDetector().detect((LevelReader)world, blockPos, null, false);
            if (result != null && result.getError() != null) {
                BlockColossalBloodChest.addPlayerChatError(player, result.getError());
            } else {
                player.m_6352_((Component)new TranslatableComponent("multiblock.evilcraft.colossalbloodchest.error.unexpected"), Util.f_137441_);
            }
        }
    }

    public static void addPlayerChatError(Player player, Component error) {
        TextComponent chat = new TextComponent("");
        MutableComponent prefix = new TextComponent("[").m_7220_((Component)new TranslatableComponent("multiblock.evilcraft.colossalbloodchest.error.prefix")).m_7220_((Component)new TextComponent("]: ")).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("multiblock.evilcraft.colossalbloodchest.error.prefix.info"))));
        chat.m_7220_((Component)prefix);
        chat.m_7220_(error);
        player.m_6352_((Component)chat, Util.f_137441_);
    }
}

