/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class BlockDarkOre
extends Block
implements IInformationProvider {
    private static final int INCREASE_XP = 5;
    public static final BooleanProperty GLOWING = BooleanProperty.m_61465_((String)"glowing");

    public BlockDarkOre(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false));
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? 1 + this.RANDOM.nextInt(5) : 0;
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        this.glow(worldIn, pos);
        super.m_6256_(state, worldIn, pos, player);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState blockState, Entity entity) {
        this.glow(world, pos);
        super.m_141947_(world, pos, blockState, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        this.glow(worldIn, pos);
        return super.m_6227_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    private boolean isGlowing(Level world, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)world.m_8055_(blockPos), (Property)GLOWING, (Comparable)Boolean.valueOf(true));
    }

    private void glow(Level world, BlockPos blockPos) {
        if (world.m_5776_()) {
            this.sparkle(world, blockPos);
        }
        if (!this.isGlowing(world, blockPos)) {
            world.m_7731_(blockPos, (BlockState)this.m_49966_().m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)GLOWING);
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos blockPos, Random rand) {
        if (this.isGlowing((Level)world, blockPos)) {
            world.m_7731_(blockPos, (BlockState)this.m_49966_().m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level world, BlockPos blockPos, Random rand) {
        if (this.isGlowing(world, blockPos)) {
            this.sparkle(world, blockPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void sparkle(Level world, BlockPos blockPos) {
        Random random = world.f_46441_;
        double offset = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double sparkX = (float)blockPos.m_123341_() + random.nextFloat();
            double sparkY = (float)blockPos.m_123342_() + random.nextFloat();
            double sparkZ = (float)blockPos.m_123343_() + random.nextFloat();
            if (l == 0 && !world.m_8055_(blockPos.m_142082_(0, 1, 0)).m_60796_((BlockGetter)world, blockPos.m_142082_(0, 1, 0))) {
                sparkY = (double)(blockPos.m_123342_() + 1) + offset;
            }
            if (l == 1 && !world.m_8055_(blockPos.m_142082_(0, -1, 0)).m_60796_((BlockGetter)world, blockPos.m_142082_(0, -1, 0))) {
                sparkY = (double)blockPos.m_123342_() - offset;
            }
            if (l == 2 && !world.m_8055_(blockPos.m_142082_(0, 0, 1)).m_60796_((BlockGetter)world, blockPos.m_142082_(0, 0, 1))) {
                sparkZ = (double)(blockPos.m_123343_() + 1) + offset;
            }
            if (l == 3 && !world.m_8055_(blockPos.m_142082_(0, 0, -1)).m_60796_((BlockGetter)world, blockPos.m_142082_(0, 0, -1))) {
                sparkZ = (double)blockPos.m_123343_() - offset;
            }
            if (l == 4 && !world.m_8055_(blockPos.m_142082_(1, 0, 0)).m_60796_((BlockGetter)world, blockPos.m_142082_(1, 0, 0))) {
                sparkX = (double)(blockPos.m_123341_() + 1) + offset;
            }
            if (l == 5 && !world.m_8055_(blockPos.m_142082_(-1, 0, 0)).m_60796_((BlockGetter)world, blockPos.m_142082_(-1, 0, 0))) {
                sparkX = (double)blockPos.m_123341_() - offset;
            }
            if (!(sparkX < (double)blockPos.m_123341_() || sparkX > (double)(blockPos.m_123341_() + 1) || sparkY < 0.0 || sparkY > (double)(blockPos.m_123342_() + 1) || sparkZ < (double)blockPos.m_123343_()) && !(sparkZ > (double)(blockPos.m_123343_() + 1))) continue;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, sparkX, sparkY, sparkZ, 0.0, 0.0, 0.0);
        }
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        return new TranslatableComponent(this.m_7705_() + ".info.custom", new Object[]{66}).m_130944_(INFO_PREFIX_STYLES);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag iTooltipFlag) {
    }
}

