/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;

public class BlockDarkTank
extends BlockWithEntity
implements IBlockTank {
    public static final String NBT_KEY_DRAINING = "enabled";
    public static final ModelProperty<FluidStack> TANK_FLUID = new ModelProperty();
    public static final ModelProperty<Integer> TANK_CAPACITY = new ModelProperty();
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.016f, (double)2.0, (double)14.0, (double)15.984f, (double)14.0);

    public BlockDarkTank(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityDarkTank::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockDarkTank.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_DARK_TANK, (BlockEntityTicker)new BlockEntityDarkTank.TickerServer());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        BlockEntityTankInventory tile = (BlockEntityTankInventory)world.m_7702_(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (Level)worldIn, (BlockPos)pos, (Direction)Direction.UP)) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_()) {
            BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)pos, BlockEntityDarkTank.class).ifPresent(tile -> {
                tile.setEnabled(!tile.isEnabled());
                player.m_5661_((Component)new TextComponent(String.format(Locale.ROOT, "%,d", tile.getTank().getFluidAmount())).m_130946_(" / ").m_130946_(String.format(Locale.ROOT, "%,d", tile.getTank().getCapacity())).m_130946_(" mB"), true);
            });
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDarkTank.class).map(tile -> tile.getTank().getFluidType() != null ? (int)Math.min(15.0, tile.getFillRatio() * (double)tile.getTank().getFluidType().getAttributes().getLuminosity(tile.getTank().getFluid()) * 15.0) : 0).orElse(0);
    }

    @Override
    public int getDefaultCapacity() {
        return 16000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.m_6047_()) {
            if (!world.m_5776_()) {
                ItemStack activated = itemStack.m_41777_();
                if (this.isActivated(itemStack, world)) {
                    activated.m_41784_().m_128473_(NBT_KEY_DRAINING);
                    if (activated.m_41783_().m_128456_()) {
                        activated.m_41751_(null);
                    }
                } else {
                    activated.m_41784_().m_128379_(NBT_KEY_DRAINING, !this.isActivated(itemStack, world));
                }
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, Level world) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128471_(NBT_KEY_DRAINING);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack((ItemLike)this);
        int capacity = capacityOriginal = 16000;
        do {
            IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack.m_41777_()).orElse(null);
            fluidHandler.setCapacity(capacity);
            list.add((Object)fluidHandler.getContainer().m_41777_());
            fluidHandler.fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, capacity), IFluidHandler.FluidAction.EXECUTE);
            list.add((Object)fluidHandler.getContainer().m_41777_());
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(BlockDarkTankConfig.maxTankCreativeSize, BlockDarkTankConfig.maxTankSize) && capacity > lastCapacity);
        if (BlockDarkTankConfig.creativeTabFluids) {
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                if (fluid == RegistryEntries.FLUID_BLOOD) continue;
                try {
                    ItemStack itemStackFilled = itemStack.m_41777_();
                    IFluidHandlerItemCapacity fluidHandlerFilled = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStackFilled).orElse(null);
                    fluidHandlerFilled.setCapacity(capacityOriginal);
                    fluidHandlerFilled.fill(new FluidStack(fluid, capacityOriginal), IFluidHandler.FluidAction.EXECUTE);
                    list.add((Object)fluidHandlerFilled.getContainer());
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }
}

