/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;

public class BlockDisplayStand
extends BlockWithEntity {
    private static final String NBT_TYPE = "displayStandType";
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty AXIS_X = BooleanProperty.m_61465_((String)"axis_x");
    public static final ModelProperty<Direction.AxisDirection> DIRECTION = new ModelProperty();
    public static final ModelProperty<ItemStack> TYPE = new ModelProperty();
    public static final Map<Direction, VoxelShape> FACING_BOUNDS = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)).put((Object)Direction.UP, (Object)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)).put((Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0)).put((Object)Direction.EAST, (Object)Block.m_49796_((double)8.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)).put((Object)Direction.NORTH, (Object)Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)8.0)).put((Object)Direction.SOUTH, (Object)Block.m_49796_((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)16.0)).build();

    public BlockDisplayStand(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityDisplayStand::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockDisplayStand.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND, (BlockEntityTicker)new BlockEntityTickerDelayed());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AXIS_X});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return FACING_BOUNDS.get(BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)FACING, (Comparable)Direction.DOWN));
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDisplayStand.class).map(tile -> !tile.getInventory().m_8020_(0).m_41619_() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
        Direction playerFacing = context.m_43723_().m_6350_();
        boolean axisX = context.m_43719_().m_122424_() == Direction.DOWN || context.m_43719_().m_122424_() == Direction.UP ? playerFacing.m_122434_() == Direction.Axis.X : playerFacing.m_122434_() != Direction.Axis.X && playerFacing.m_122434_() != Direction.Axis.Z;
        blockState = (BlockState)blockState.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(axisX));
        return blockState;
    }

    public void m_6402_(Level world, BlockPos blockPos, BlockState blockState, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, blockPos, blockState, entity, stack);
        if (!world.m_5776_()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDisplayStand.class).ifPresent(tile -> {
                tile.setDisplayStandType(this.getDisplayStandType(stack));
                tile.setDirection(entity.m_6350_().m_122421_());
            });
        }
    }

    public BlockState rotate(BlockState blockState, LevelAccessor world, BlockPos pos, Rotation direction) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDisplayStand.class).map(tile -> {
            if (tile.getDirection() == Direction.AxisDirection.POSITIVE) {
                if (((Boolean)blockState.m_61143_((Property)AXIS_X)).booleanValue()) {
                    tile.setDirection(Direction.AxisDirection.POSITIVE);
                    return (BlockState)blockState.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false));
                }
                tile.setDirection(Direction.AxisDirection.NEGATIVE);
                return (BlockState)blockState.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)blockState.m_61143_((Property)AXIS_X)).booleanValue()) {
                tile.setDirection(Direction.AxisDirection.NEGATIVE);
                return (BlockState)blockState.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false));
            }
            tile.setDirection(Direction.AxisDirection.POSITIVE);
            return (BlockState)blockState.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
        }).orElse(blockState);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> list) {
        try {
            for (Item item : ItemTags.f_13168_.m_6497_()) {
                if (!(item instanceof BlockItem)) continue;
                BlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)new ItemStack((ItemLike)item));
                list.add((Object)this.getTypedDisplayStandItem(plankWoodBlockState));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public ItemStack getTypedDisplayStandItem(BlockState blockState) {
        CompoundTag blockTag = BlockHelpers.serializeBlockState((BlockState)blockState);
        ItemStack itemStack = new ItemStack((ItemLike)this);
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128365_(NBT_TYPE, (Tag)blockTag);
        return itemStack;
    }

    public ItemStack getDisplayStandType(ItemStack displayStandStack) {
        CompoundTag tag = displayStandStack.m_41783_();
        if (tag != null && tag.m_128441_(NBT_TYPE)) {
            BlockState blockState = BlockHelpers.deserializeBlockState((CompoundTag)tag.m_128469_(NBT_TYPE));
            return BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
        }
        return null;
    }

    public static void setDisplayStandType(ItemStack displayStandStack, ItemStack type) {
        CompoundTag tag = displayStandStack.m_41784_();
        tag.m_128365_(NBT_TYPE, (Tag)BlockHelpers.serializeBlockState((BlockState)BlockHelpers.getBlockStateFromItemStack((ItemStack)type)));
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().m_41619_() && event.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && event.getWorld().m_8055_(event.getPos()).m_60734_() == this) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntityDisplayStand tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDisplayStand.class).orElse(null);
        if (tile != null) {
            ItemStack tileStack = tile.getInventory().m_8020_(0);
            if ((itemStack.m_41619_() || ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)tileStack) && ItemStack.m_41658_((ItemStack)itemStack, (ItemStack)tileStack) && tileStack.m_41613_() < tileStack.m_41741_()) && !tileStack.m_41619_()) {
                if (!itemStack.m_41619_()) {
                    tileStack.m_41769_(itemStack.m_41613_());
                }
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, tileStack);
                tile.getInventory().m_6836_(0, ItemStack.f_41583_);
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.m_41619_() && tile.getInventory().m_8020_(0).m_41619_()) {
                tile.getInventory().m_6836_(0, itemStack.m_41620_(1));
                if (itemStack.m_41613_() <= 0) {
                    player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                }
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        ItemStack blockType = this.getDisplayStandType(stack);
        if (blockType != null) {
            tooltip.add((Component)((MutableComponent)blockType.m_41786_()).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return BlockHelpers.doesBlockHaveSolidTopSurface((LevelReader)worldIn, (BlockPos)pos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6810_(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!world.m_5776_() && oldState.m_60734_() != newState.m_60734_()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDisplayStand.class).ifPresent(tile -> InventoryHelpers.dropItems((Level)world, (Container)tile.getInventory(), (BlockPos)blockPos));
        }
        super.m_6810_(oldState, world, blockPos, newState, isMoving);
    }
}

