/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.block.BlockInfestedNether;

public class BlockInfestedNetherConfig
extends BlockConfig {
    private final BlockInfestedNether.Type type;
    public static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_NETHERFISH;
    public static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_SILVERFISH_EXTRA;
    public static PlacedFeature PLACED_FEATURE_NETHERFISH;
    public static PlacedFeature PLACED_FEATURE_SILVERFISH_EXTRA;

    public BlockInfestedNetherConfig(BlockInfestedNether.Type type) {
        super((ModBase)EvilCraft._instance, "infested_nether_" + type.name().toLowerCase(), eConfig -> new BlockInfestedNether(BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60978_(0.0f), type), BlockInfestedNetherConfig.getDefaultItemConstructor((ModBase)EvilCraft._instance));
        this.type = type;
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        CONFIGURED_FEATURE_NETHERFISH = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), "stone_netherfish"), (Object)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreFeatures.f_195075_, ((Block)this.getInstance()).m_49966_(), 9)));
        CONFIGURED_FEATURE_SILVERFISH_EXTRA = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), "stone_nether_silverfish_extra"), (Object)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreFeatures.f_195071_, Blocks.f_50226_.m_49966_(), 4)));
        PLACED_FEATURE_NETHERFISH = (PlacedFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), "stone_netherfish"), (Object)CONFIGURED_FEATURE_NETHERFISH.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), BiomeFilter.m_191561_()}));
        PLACED_FEATURE_SILVERFISH_EXTRA = (PlacedFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), "stone_nether_silverfish_extra"), (Object)CONFIGURED_FEATURE_SILVERFISH_EXTRA.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)66)), BiomeFilter.m_191561_()}));
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (this.type == BlockInfestedNether.Type.NETHERRACK && event.getCategory() == Biome.BiomeCategory.NETHER) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).add(() -> PLACED_FEATURE_NETHERFISH);
        }
        if (this.type != BlockInfestedNether.Type.NETHERRACK && GeneralConfig.extraSilverfish && event.getCategory() != Biome.BiomeCategory.THEEND && event.getCategory() != Biome.BiomeCategory.NETHER) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).add(() -> PLACED_FEATURE_SILVERFISH_EXTRA);
        }
    }
}

