/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritPortal;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;

public class BlockSpiritPortal
extends BlockWithEntity {
    public static final VoxelShape SHAPE = Block.m_49796_((double)6.4f, (double)6.4f, (double)6.4f, (double)9.6f, (double)9.6f, (double)9.6f);

    public BlockSpiritPortal(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySpiritPortal::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockSpiritPortal.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_SPIRIT_PORTAL, (BlockEntityTicker)new BlockEntitySpiritPortal.Ticker());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    protected static boolean canReplaceBlock(BlockState blockState, LevelReader world, BlockPos pos) {
        return blockState != null && (blockState.m_60795_() || blockState.m_60767_().m_76336_());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void palingDeath(LivingDeathEvent event) {
        if (event.getSource() == ExtendedDamageSource.paling) {
            this.tryPlacePortal(event.getEntityLiving().f_19853_, event.getEntityLiving().m_142538_().m_142082_(0, 1, 0));
        }
    }

    public boolean tryPlacePortal(Level world, BlockPos blockPos) {
        RegionIterator it = new RegionIterator(blockPos, 1, true);
        for (int attempts = 9; it.hasNext() && attempts >= 0; --attempts) {
            BlockPos location = it.next();
            if (!BlockSpiritPortal.canReplaceBlock(world.m_8055_(location), (LevelReader)world, blockPos)) continue;
            world.m_7731_(location, RegistryEntries.BLOCK_SPIRIT_PORTAL.m_49966_(), 3);
            return true;
        }
        return false;
    }
}

