/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.block.component.ParticleDropBlockComponent;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockUndeadLeavesConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;

public class BlockUndeadLeaves
extends LeavesBlock {
    private ParticleDropBlockComponent particleDropBlockComponent;

    public BlockUndeadLeaves(BlockBehaviour.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            this.particleDropBlockComponent = new ParticleDropBlockComponent(1.0f, 0.0f, 0.0f);
            this.particleDropBlockComponent.setOffset(0);
            this.particleDropBlockComponent.setChance(50);
        }
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        super.m_7100_(stateIn, worldIn, pos, rand);
        this.particleDropBlockComponent.randomDisplayTick(stateIn, worldIn, pos, rand);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this);
    }

    protected boolean canFormBloodStains(BlockState state) {
        return BlockUndeadLeavesConfig.maxBloodStainAmount > 0 && (Boolean)state.m_61143_((Property)f_54419_) == false && (Integer)state.m_61143_((Property)f_54418_) == 2;
    }

    public boolean m_6724_(BlockState state) {
        return super.m_6724_(state) || this.canFormBloodStains(state);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        super.m_7455_(state, worldIn, pos, random);
        if (this.canFormBloodStains(state)) {
            int attempts = 20;
            BlockPos itPos = pos.m_142300_(Direction.DOWN);
            while (attempts-- > 0) {
                if (worldIn.m_8055_(itPos).m_60734_() instanceof BlockBloodStain || worldIn.m_46859_(itPos) && RegistryEntries.BLOCK_BLOOD_STAIN.m_7898_(state, (LevelReader)worldIn, itPos)) {
                    BlockState blockState = worldIn.m_8055_(itPos);
                    if (worldIn.m_46859_(itPos)) {
                        blockState = RegistryEntries.BLOCK_BLOOD_STAIN.m_49966_();
                        worldIn.m_46597_(itPos, blockState);
                    }
                    if (!(blockState.m_60734_() instanceof BlockBloodStain)) break;
                    BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)itPos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(1 + worldIn.f_46441_.nextInt(BlockUndeadLeavesConfig.maxBloodStainAmount)));
                    break;
                }
                if (!worldIn.m_46859_(itPos)) break;
                itPos = itPos.m_142300_(Direction.DOWN);
            }
        }
    }
}

