/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.block.BlockEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedData;
import org.cyclops.evilcraft.client.particle.ParticleBubbleExtendedData;
import org.cyclops.evilcraft.core.blockentity.BlockEntityBeacon;
import org.cyclops.evilcraft.core.degradation.DegradationExecutor;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public class BlockEntityEnvironmentalAccumulator
extends BlockEntityBeacon
implements IDegradable {
    public static final int MAX_AGE = 50;
    public static final int SPREAD = 25;
    private static final int ITEM_MOVE_COOLDOWN_DURATION = 1;
    private static final double WEATHER_CONTAINER_MIN_DROP_HEIGHT = 0.0;
    private static final double WEATHER_CONTAINER_MAX_DROP_HEIGHT = 2.0;
    private static final double WEATHER_CONTAINER_SPAWN_HEIGHT = (double)BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount * BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed + 1.0;
    private static final float ITEM_MIN_SPAWN_HEIGHT = 1.0f;
    private static final int DEGRADATION_RADIUS_BASE = 5;
    private static final int DEGRADATION_TICK_INTERVAL = 100;
    private DegradationExecutor degradationExecutor;
    private int degradation = 0;
    private BlockPos location = null;
    private static final BlockPos[] waterOffsets = new BlockPos[]{new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(2, -1, 2)};
    private ServerBossEvent bossInfo = null;
    private int state = 0;
    private int tick = 0;
    private Inventory inventory;
    @Nullable
    private RecipeEnvironmentalAccumulator recipe;
    private String recipeId;

    public BlockEntityEnvironmentalAccumulator(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_ENVIRONMENTAL_ACCUMULATOR, blockPos, blockState);
        this.recreateBossInfo();
        this.degradationExecutor = new DegradationExecutor(this);
        this.inventory = new Inventory(this);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((Inventory)this.inventory).getItemHandler()));
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        if (MinecraftHelpers.isClientSide()) {
            this.setBeamColor(this.getOuterColorByState(this.state));
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    protected void recreateBossInfo() {
        this.bossInfo = (ServerBossEvent)new ServerBossEvent((Component)new TranslatableComponent("chat.evilcraft.boss_display.charge"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);
    }

    protected Triple<Float, Float, Float> getBaseBeamColor() {
        if (this.m_58904_() == null) {
            return Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        Biome biome = this.m_58904_().m_46857_(this.m_58899_());
        return Helpers.intToRGB((int)biome.m_47464_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123343_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vector4f getOuterColorByState(int state) {
        Triple<Float, Float, Float> baseColor = this.getBaseBeamColor();
        float coolFactor = (float)(this.getMaxCooldownTick() - this.tick) / (float)this.getMaxCooldownTick();
        if (state == 1) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.05f);
        }
        if (state == 0) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.13f);
        }
        return new Vector4f(((Float)baseColor.getLeft()).floatValue() * coolFactor, ((Float)baseColor.getMiddle()).floatValue() * coolFactor, ((Float)baseColor.getRight()).floatValue() * coolFactor, 0.13f);
    }

    public int getMaxCooldownTick() {
        return this.recipe == null ? BlockEnvironmentalAccumulatorConfig.defaultTickCooldown : this.recipe.getCooldownTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMovingItemY() {
        if (this.state == 1) {
            return 1.0f + (float)(this.getItemMoveDuration() - this.tick) * this.getItemMoveSpeed();
        }
        return -1.0f;
    }

    public RecipeEnvironmentalAccumulator getRecipe() {
        return this.recipe;
    }

    private int getItemMoveDuration() {
        if (this.recipe == null) {
            return BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.recipe.getDuration();
    }

    private float getItemMoveSpeed() {
        if (this.recipe == null) {
            return (float)BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return this.recipe.getProcessingSpeed();
    }

    public void m_7651_() {
        super.m_7651_();
        this.getBossInfo().m_7706_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showWaterBeams() {
        Random random = this.f_58857_.f_46441_;
        BlockPos target = this.m_58899_();
        for (int j = 0; j < waterOffsets.length; ++j) {
            BlockPos offset = waterOffsets[j];
            BlockPos location = target.m_141952_((Vec3i)offset);
            double x = (double)location.m_123341_() + 0.5;
            double y = (double)location.m_123342_() + 0.5;
            double z = (double)location.m_123343_() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < random.nextInt(2); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 2.0;
                double particleMotionX = (double)(Mth.m_14031_((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)Mth.m_14089_((float)(rotationPitch / 180.0f * (float)Math.PI)) * speed * 5.0;
                double particleMotionZ = (double)(Mth.m_14031_((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.m_14031_((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBubbleExtendedData(0.02f), false, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showAccumulatingParticles() {
        BlockEntityEnvironmentalAccumulator.showAccumulatingParticles(this.f_58857_, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 0.5f, (float)this.m_58899_().m_123343_() + 0.5f, 25.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showAccumulatingParticles(Level world, float centerX, float centerY, float centerZ, float spread) {
        Random rand = world.f_46441_;
        for (int j = 0; j < rand.nextInt(20); ++j) {
            float scale = 0.6f - rand.nextFloat() * 0.4f;
            float red = rand.nextFloat() * 0.1f + 0.2f;
            float green = rand.nextFloat() * 0.1f + 0.3f;
            float blue = rand.nextFloat() * 0.1f + 0.2f;
            float ageMultiplier = 60.0f;
            float motionX = spread - rand.nextFloat() * 2.0f * spread;
            float motionY = spread - rand.nextFloat() * 2.0f * spread;
            float motionZ = spread - rand.nextFloat() * 2.0f * spread;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurTargettedData(red, green, blue, scale, ageMultiplier, centerX, centerY, centerZ), false, (double)centerX, (double)centerY, (double)centerZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    protected RecipeType<RecipeEnvironmentalAccumulator> getRegistry() {
        return RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
    }

    private void updateEnvironmentalAccumulatorIdle() {
        List entityItems = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_() + 0.0, (double)this.m_58899_().m_123343_(), (double)this.m_58899_().m_123341_() + 1.0, (double)this.m_58899_().m_123342_() + 2.0, (double)this.m_58899_().m_123343_() + 1.0));
        for (RecipeEnvironmentalAccumulator recipe : CraftingHelpers.findRecipes((Level)this.f_58857_, this.getRegistry())) {
            Ingredient recipeIngredient = recipe.getInputIngredient();
            WeatherType weatherType = recipe.getInputWeather();
            for (Object obj : entityItems) {
                ItemEntity entityItem = (ItemEntity)obj;
                ItemStack stack = entityItem.m_32055_();
                if (!recipeIngredient.test(stack) || weatherType != null && !weatherType.isActive(this.f_58857_)) continue;
                this.getInventory().m_6836_(0, stack.m_41777_());
                this.recipe = recipe;
                if (!this.f_58857_.m_5776_()) {
                    this.decreaseStackSize(entityItem, 1);
                }
                this.activateProcessingItemState();
                return;
            }
        }
    }

    private void decreaseStackSize(ItemEntity entityItem, int count) {
        entityItem.m_32055_().m_41774_(count);
        if (entityItem.m_32055_().m_41613_() == 0) {
            entityItem.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void dropItemStack() {
        if (!this.f_58857_.m_5776_()) {
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_() + WEATHER_CONTAINER_SPAWN_HEIGHT, (double)this.m_58899_().m_123343_(), ItemStack.f_41583_);
            if (this.recipe == null) {
                entity.m_32045_(this.getInventory().m_8020_(0));
            } else {
                WeatherType weatherResult;
                entity.m_32045_(this.recipe.assemble(this.getInventory()));
                WeatherType weatherSource = this.recipe.getInputWeather();
                if (weatherSource != null) {
                    weatherSource.deactivate((ServerLevel)this.f_58857_);
                }
                if ((weatherResult = this.recipe.getOutputWeather()) != null) {
                    weatherResult.activate((ServerLevel)this.f_58857_);
                }
            }
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    private void activateIdleState() {
        this.tick = 0;
        this.state = 0;
        if (!this.f_58857_.m_5776_()) {
            this.sendUpdate();
            this.m_6596_();
        }
    }

    private void activateProcessingItemState() {
        this.tick = this.recipe == null ? BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount : this.recipe.getDuration();
        this.state = 1;
        if (!this.f_58857_.m_5776_()) {
            this.sendUpdate();
            this.m_6596_();
        }
    }

    private void activateFinishedProcessingItemState() {
        this.tick = 1;
        this.state = 3;
        if (!this.f_58857_.m_5776_()) {
            this.sendUpdate();
            this.m_6596_();
        }
    }

    private void activateCooldownState() {
        ++this.degradation;
        this.degradationExecutor.setTickInterval(100 / this.degradation);
        this.tick = this.getMaxCooldownTick();
        this.state = 2;
        this.recipe = null;
        if (!this.f_58857_.m_5776_()) {
            this.sendUpdate();
            this.m_6596_();
        }
    }

    public void onUpdateReceived() {
        if (this.f_58857_.m_5776_() && this.state == 3) {
            this.f_58857_.m_6798_(2002, this.m_58899_().m_142022_(0.0, WEATHER_CONTAINER_SPAWN_HEIGHT, 0.0), 16428);
        }
        this.setBeamColor(this.state);
    }

    public void setBeamColor(int state) {
        if (this.f_58857_.m_5776_()) {
            this.setBeamColor(this.getOuterColorByState(state));
        }
    }

    public int getState() {
        return this.state;
    }

    public void read(CompoundTag compound) {
        super.read(compound);
        this.inventory.readFromNBT(compound, "inventory");
        this.degradation = compound.m_128451_("degradation");
        this.tick = compound.m_128451_("tick");
        this.state = compound.m_128451_("state");
        this.recipeId = compound.m_128461_("recipe");
        this.degradationExecutor.read(compound);
        if (this.m_58904_() != null && this.m_58904_().m_5776_()) {
            this.setBeamColor(this.getOuterColorByState(this.state));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.inventory.writeToNBT(tag, "inventory");
        tag.m_128405_("degradation", this.degradation);
        tag.m_128405_("tick", this.tick);
        tag.m_128405_("state", this.state);
        if (this.recipe != null) {
            tag.m_128359_("recipe", this.recipe.m_6423_().toString());
        }
        this.degradationExecutor.write(tag);
    }

    public float getMaxHealth() {
        if (this.state == 1) {
            return this.getItemMoveDuration();
        }
        if (this.state == 3) {
            return 0.0f;
        }
        return this.getMaxCooldownTick();
    }

    public float getHealth() {
        if (this.state == 1) {
            return this.tick;
        }
        if (this.state == 2) {
            return this.getMaxCooldownTick() - this.tick;
        }
        return this.getMaxCooldownTick();
    }

    @Override
    public BlockPos getLocation() {
        return this.m_58899_();
    }

    @Override
    public int getRadius() {
        return 5 + this.degradation / 10;
    }

    @Override
    public List<Entity> getAreaEntities() {
        return EntityHelpers.getEntitiesInArea((Level)this.getDegradationWorld(), (BlockPos)this.m_58899_(), (int)this.getRadius());
    }

    @Override
    public double getDegradation() {
        return this.degradation;
    }

    @Override
    public Level getDegradationWorld() {
        return this.m_58904_();
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public static class Inventory
    extends SimpleInventory
    implements RecipeEnvironmentalAccumulator.Inventory {
        private final BlockEntityEnvironmentalAccumulator tile;

        public Inventory(BlockEntityEnvironmentalAccumulator tile) {
            super(1, 64);
            this.tile = tile;
        }

        @Override
        public Level getWorld() {
            return this.tile.m_58904_();
        }

        @Override
        public BlockPos getPos() {
            return this.tile.m_58899_();
        }
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityEnvironmentalAccumulator> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEnvironmentalAccumulator blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (blockEntity.recipeId != null && level != null) {
                blockEntity.recipe = level.m_7465_().m_44043_(new ResourceLocation(blockEntity.recipeId)).orElse(null);
                blockEntity.recipeId = null;
            }
            if (blockEntity.tick > 0) {
                --blockEntity.tick;
            }
            if (blockEntity.state == 0) {
                blockEntity.updateEnvironmentalAccumulatorIdle();
            } else if (blockEntity.state == 1) {
                if (level.m_5776_()) {
                    blockEntity.showWaterBeams();
                    if (blockEntity.tick > 50) {
                        blockEntity.showAccumulatingParticles();
                    }
                }
                if (blockEntity.tick == 0) {
                    blockEntity.dropItemStack();
                    blockEntity.activateFinishedProcessingItemState();
                    blockEntity.getBossInfo().m_7706_();
                    blockEntity.recreateBossInfo();
                } else {
                    blockEntity.sendUpdate();
                }
            } else if (blockEntity.state == 3) {
                if (blockEntity.tick == 0) {
                    blockEntity.activateCooldownState();
                    blockEntity.getInventory().m_7407_(0, blockEntity.getInventory().m_6893_());
                } else {
                    blockEntity.sendUpdate();
                }
            } else if (blockEntity.state == 2) {
                blockEntity.setBeamColor(blockEntity.state);
                blockEntity.degradationExecutor.runRandomEffect(level.m_5776_());
                if (blockEntity.tick == 0) {
                    blockEntity.activateIdleState();
                } else {
                    blockEntity.sendUpdate();
                }
            }
            if (!level.m_5776_()) {
                blockEntity.getBossInfo().m_142711_(blockEntity.getHealth() / blockEntity.getMaxHealth());
                HashSet playerIds = Sets.newHashSet();
                if (blockEntity.getHealth() != blockEntity.getMaxHealth()) {
                    for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(32.0))) {
                        blockEntity.getBossInfo().m_6543_((ServerPlayer)player);
                        playerIds.add(player.m_142049_());
                    }
                }
                ArrayList players = Lists.newArrayList((Iterable)blockEntity.getBossInfo().m_8324_());
                for (ServerPlayer playerMP : players) {
                    if (playerIds.contains(playerMP.m_142049_()) && blockEntity.getHealth() != 0.0f) continue;
                    blockEntity.getBossInfo().m_6539_(playerMP);
                }
            }
        }
    }
}

