/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntityEternalWater
extends CyclopsBlockEntity {
    public static final FluidStack WATER = new FluidStack((Fluid)Fluids.f_76193_, Integer.MAX_VALUE);

    public BlockEntityEternalWater(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_ETERNAL_WATER, blockPos, blockState);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(InfiniteWaterFluidCapability::new));
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityEternalWater> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEternalWater blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            for (Direction direction : Direction.values()) {
                BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)pos.m_142300_(direction), (Direction)direction.m_122424_(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> handler.fill(WATER, IFluidHandler.FluidAction.EXECUTE));
            }
        }
    }

    public static class InfiniteWaterFluidCapability
    implements IFluidHandler {
        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return WATER;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getFluid() != WATER.getFluid()) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(WATER.getFluid(), resource.getAmount());
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack(WATER.getFluid(), maxDrain);
        }
    }
}

