/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntitySpiritPortal
extends CyclopsBlockEntity {
    @NBTPersist
    private Float progress = Float.valueOf(0.0f);

    public BlockEntitySpiritPortal(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_SPIRIT_PORTAL, blockPos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showNewBlurParticle() {
        Random rand = this.f_58857_.f_46441_;
        float scale = 0.6f - rand.nextFloat() * 0.3f;
        float red = rand.nextFloat() * 0.03f + 0.01f;
        float green = rand.nextFloat() * 0.03f;
        float blue = rand.nextFloat() * 0.05f + 0.05f;
        float ageMultiplier = (float)(rand.nextDouble() * 6.5 + 10.0);
        Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), (double)(rand.nextFloat() * 0.2f - 0.1f), (double)(rand.nextFloat() * 0.2f - 0.1f), (double)(rand.nextFloat() * 0.2f - 0.1f));
    }

    public float getProgress() {
        return this.progress.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntitySpiritPortal> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySpiritPortal blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            BlockEntitySpiritPortal blockEntitySpiritPortal = blockEntity;
            blockEntitySpiritPortal.progress = Float.valueOf(blockEntitySpiritPortal.progress.floatValue() + 0.005f);
            if (blockEntity.progress.floatValue() > 1.0f) {
                level.m_7471_(pos, false);
            }
            if (level.m_5776_()) {
                int progressModifier = (int)(blockEntity.getProgress() * 40.0f) + 1;
                if (level.f_46441_.nextInt(5) == 0) {
                    level.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), EvilCraftSoundEvents.effect_vengeancebeam_base, SoundSource.AMBIENT, 0.5f + level.f_46441_.nextFloat() * 0.2f, 1.0f, false);
                }
                for (int i = 0; i < level.f_46441_.nextInt(progressModifier); ++i) {
                    blockEntity.showNewBlurParticle();
                }
            }
            if (!level.m_5776_()) {
                for (ItemEntity entityItem : level.m_45976_(ItemEntity.class, new AABB((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5, (double)pos.m_123341_() + 1.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 1.5))) {
                    if (!(entityItem.m_32055_().m_41720_() instanceof BookItem)) continue;
                    ItemEntity entity = new ItemEntity(level, entityItem.m_20185_(), entityItem.m_20186_(), entityItem.m_20189_(), new ItemStack((ItemLike)RegistryEntries.ITEM_ORIGINS_OF_DARKNESS, entityItem.m_32055_().m_41613_()));
                    entity.m_20256_(entityItem.m_20184_());
                    entityItem.m_142687_(Entity.RemovalReason.DISCARDED);
                    level.m_7967_((Entity)entity);
                }
            }
        }
    }
}

