/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.block.BlockSpiritReanimator;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.spiritreanimator.ReanimateTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;

public class BlockEntitySpiritReanimator
extends BlockEntityWorking<BlockEntitySpiritReanimator, MutableDouble>
implements MenuProvider {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int SLOT_EGG = 2;
    public static final int SLOTS_OUTPUT = 3;
    public static final int SLOTS = 4;
    public static Metadata METADATA = new Metadata();
    public static final int LIQUID_PER_SLOT = 10000;
    private static final Map<Class<?>, ITickAction<BlockEntitySpiritReanimator>> REANIMATE_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<BlockEntitySpiritReanimator>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private int reanimateTicker = this.addTicker(new TickComponent<BlockEntitySpiritReanimator, ITickAction<BlockEntitySpiritReanimator>>(this, REANIMATE_COOK_TICK_ACTIONS, 1, true, false));
    @NBTPersist
    private Boolean caughtError = false;

    public BlockEntitySpiritReanimator(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_SPIRIT_REANIMATOR, blockPos, blockState, 4, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.addTicker(new TickComponent<BlockEntitySpiritReanimator, ITickAction<BlockEntitySpiritReanimator>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntitySpiritReanimator, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(BlockEntitySpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntitySpiritReanimator, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(BlockEntitySpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerInput = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{2}));
        LazyOptional itemHandlerOutput = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{3}));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0, 1}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerInput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerOutput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new BlockEntityWorking.Inventory<BlockEntitySpiritReanimator>(inventorySize, stackSize, this){

            @Override
            public boolean m_7013_(int slot, ItemStack itemStack) {
                if (slot == 1) {
                    return BlockEntitySpiritReanimator.this.getTileWorkingMetadata().canConsume(itemStack, BlockEntitySpiritReanimator.this.m_58904_());
                }
                if (slot == 2) {
                    return itemStack.m_41720_() == Items.f_42521_;
                }
                if (slot == 0) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                return super.m_7013_(slot, itemStack);
            }
        };
    }

    public Direction getRotation() {
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.m_58904_().m_8055_(this.m_58899_()), (Property)BlockSpiritReanimator.FACING, (Comparable)Direction.NORTH)).m_122424_();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.reanimateTicker;
    }

    @Nullable
    public EntityType<?> getEntityType() {
        ItemStack boxStack = this.getInventory().m_8020_(this.getConsumeSlot());
        if (boxStack.m_41720_() == BlockEntitySpiritReanimator.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getSpiritTypeRaw(boxStack.m_41783_());
        }
        return null;
    }

    public static Item getAllowedCookItem() {
        return RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE;
    }

    public int getConsumeSlot() {
        return 1;
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        ItemStack eggStack = this.getInventory().m_8020_(2);
        ItemStack outputStack = this.getInventory().m_8020_(3);
        EntityType<?> entityType = this.getEntityType();
        boolean validNameStack = entityType != null && (outputStack.m_41619_() || outputStack.m_41741_() > outputStack.m_41613_() && SpawnEggItem.f_43201_.get(entityType) == outputStack.m_41720_());
        return !eggStack.m_41619_() && validNameStack;
    }

    @Override
    public void onStateChanged() {
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BlockSpiritReanimator.ON, (Comparable)Boolean.valueOf(this.isWorking())));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerSpiritReanimator(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.evilcraft.spirit_reanimator");
    }

    static {
        REANIMATE_COOK_TICK_ACTIONS.put(BlockBoxOfEternalClosure.class, new ReanimateTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }

    private static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(4);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            return !itemStack.m_41619_() && BlockEntitySpiritReanimator.getAllowedCookItem() == itemStack.m_41720_();
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_SPIRIT_REANIMATOR;
        }
    }
}

