/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;

public class ContainerScreenSanguinaryEnvironmentalAccumulator
extends ContainerScreenTileWorking<ContainerSanguinaryEnvironmentalAccumulator, BlockEntitySanguinaryEnvironmentalAccumulator> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int PROGRESSWIDTH = 24;
    public static final int PROGRESSHEIGHT = 16;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 77;
    public static final int PROGRESSTARGETY = 36;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 18;

    public ContainerScreenSanguinaryEnvironmentalAccumulator(ContainerSanguinaryEnvironmentalAccumulator container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setProgress(24, 16, 192, 0, 77, 36);
    }

    @Override
    protected Component getName() {
        return new TranslatableComponent("block.evilcraft.sanguinary_environmental_accumulator");
    }

    @Override
    protected void drawAdditionalForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        super.drawAdditionalForeground(matrixStack, mouseX, mouseY);
        String prefix = RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.m_7705_() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(new TranslatableComponent(prefix));
        if (!((ContainerSanguinaryEnvironmentalAccumulator)this.m_6262_()).getTileCanWork()) {
            lines.add(new TranslatableComponent(prefix + ".invalid_locations"));
            for (Vec3i location : ((ContainerSanguinaryEnvironmentalAccumulator)this.m_6262_()).getInvalidLocations()) {
                lines.add(new TextComponent(String.format("  X=%s Y=%s Z=%s", location.m_123341_(), location.m_123342_(), location.m_123343_())));
            }
        }
        if (lines.size() > 1) {
            this.m_93228_(matrixStack, 77 + this.offsetX, 36 + this.offsetY, 192, 18, 24, 16);
            if (this.m_6774_(77 + this.offsetX, 36 + this.offsetY, 24, 16, mouseX, mouseY)) {
                this.drawTooltip(lines, matrixStack, mouseX -= this.f_97735_, mouseY -= this.f_97736_);
            }
        }
    }

    public ResourceLocation constructGuiTexture() {
        return new ResourceLocation("evilcraft", "textures/gui/sanguinary_environmental_accumulator_gui.png");
    }
}

