/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;

public class ContainerScreenSpiritFurnace
extends ContainerScreenTileWorking<ContainerSpiritFurnace, BlockEntitySpiritFurnace> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int TANKWIDTH = 16;
    public static final int TANKHEIGHT = 58;
    public static final int TANKX = 176;
    public static final int TANKY = 0;
    public static final int TANKTARGETX = 43;
    public static final int TANKTARGETY = 72;
    public static final int PROGRESSWIDTH = 24;
    public static final int PROGRESSHEIGHT = 16;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 102;
    public static final int PROGRESSTARGETY = 36;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 18;

    public ContainerScreenSpiritFurnace(ContainerSpiritFurnace container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setTank(16, 58, 176, 0, 43, 72);
        this.setProgress(24, 16, 192, 0, 102, 36);
    }

    @Override
    protected Component getName() {
        return new TranslatableComponent("block.evilcraft.spirit_furnace");
    }

    public ResourceLocation constructGuiTexture() {
        return new ResourceLocation("evilcraft", "textures/gui/spirit_furnace_gui.png");
    }

    private String prettyPrintSize(@Nullable Vec3i size) {
        if (size == null) {
            return "Loading...";
        }
        return size.m_123341_() + "x" + size.m_123342_() + "x" + size.m_123343_();
    }

    @Override
    protected void drawAdditionalForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        String prefix = RegistryEntries.BLOCK_SPIRIT_FURNACE.m_7705_() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(new TranslatableComponent(prefix));
        if (!((ContainerSpiritFurnace)this.m_6262_()).hasEntity()) {
            lines.add(new TranslatableComponent(prefix + ".no_entity"));
        } else if (!((ContainerSpiritFurnace)this.m_6262_()).isSizeValidForEntity()) {
            lines.add(new TranslatableComponent(prefix + ".content_size", new Object[]{this.prettyPrintSize(((ContainerSpiritFurnace)this.m_6262_()).getInnerSize())}));
            lines.add(new TranslatableComponent(prefix + ".required_size", new Object[]{this.prettyPrintSize(((ContainerSpiritFurnace)this.m_6262_()).getEntitySize())}));
        } else if (((ContainerSpiritFurnace)this.m_6262_()).isForceHalt()) {
            lines.add(new TranslatableComponent(prefix + ".force_halt"));
        } else if (((ContainerSpiritFurnace)this.m_6262_()).isCaughtError()) {
            lines.add(new TranslatableComponent(prefix + ".caught_error"));
        }
        if (lines.size() > 1) {
            this.m_93228_(matrixStack, 102 + this.offsetX, 36 + this.offsetY, 192, 18, 24, 16);
            if (this.m_6774_(102 + this.offsetX, 36 + this.offsetY, 24, 16, mouseX, mouseY)) {
                this.drawTooltip(lines, matrixStack, mouseX -= this.f_97735_, mouseY -= this.f_97736_);
            }
        }
    }
}

