/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritReanimator;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;

public class ContainerScreenSpiritReanimator
extends ContainerScreenTileWorking<ContainerSpiritReanimator, BlockEntitySpiritReanimator> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int TANKWIDTH = 16;
    public static final int TANKHEIGHT = 58;
    public static final int TANKX = 176;
    public static final int TANKY = 0;
    public static final int TANKTARGETX = 43;
    public static final int TANKTARGETY = 72;
    public static final int PROGRESSWIDTH = 10;
    public static final int PROGRESSHEIGHT = 24;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 119;
    public static final int PROGRESSTARGETY = 26;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 24;

    public ContainerScreenSpiritReanimator(ContainerSpiritReanimator container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setTank(16, 58, 176, 0, 43, 72);
        this.setProgress(10, 24, 192, 0, 119, 26);
    }

    @Override
    protected Component getName() {
        return new TranslatableComponent("block.evilcraft.spirit_reanimator");
    }

    public ResourceLocation constructGuiTexture() {
        return new ResourceLocation("evilcraft", "textures/gui/spirit_reanimator_gui.png");
    }

    @Override
    protected void drawAdditionalForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        String prefix = RegistryEntries.BLOCK_SPIRIT_REANIMATOR.m_7705_() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(new TranslatableComponent(prefix));
        String entityName = ((ContainerSpiritReanimator)this.m_6262_()).getEntityName();
        if (entityName == null) {
            lines.add(new TranslatableComponent(prefix + ".no_entity"));
        } else if (entityName.isEmpty()) {
            lines.add(new TranslatableComponent(prefix + ".invalid_entity"));
        } else {
            ItemStack outputStack = ((ContainerSpiritReanimator)this.m_6262_()).getContainerInventory().m_8020_(3);
            if (!outputStack.m_41619_() && outputStack.m_41720_() instanceof SpawnEggItem && ((SpawnEggItem)outputStack.m_41720_()).m_43228_(outputStack.m_41783_()) != ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityName))) {
                lines.add(new TranslatableComponent(prefix + ".different_egg"));
            }
        }
        if (lines.size() > 1) {
            this.m_93228_(matrixStack, 119 + this.offsetX, 26 + this.offsetY, 192, 24, 10, 24);
            if (this.m_6774_(119 + this.offsetX, 26 + this.offsetY, 10, 24, mouseX, mouseY)) {
                this.drawTooltip(lines, matrixStack, mouseX -= this.f_97735_, mouseY -= this.f_97736_);
            }
        }
    }

    @Override
    protected int getProgressXScaled(int width) {
        return width;
    }

    @Override
    protected int getProgressYScaled(int height) {
        return ((ContainerSpiritReanimator)this.m_6262_()).getProgress(0) * 24 / ((ContainerSpiritReanimator)this.m_6262_()).getMaxProgress(0);
    }
}

