/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.blockentity.tickaction.purifier.DisenchantPurifyAction;

public class RenderBlockEntityPurifier
implements BlockEntityRenderer<BlockEntityPurifier> {
    public static final Material TEXTURE_BLOOK = new Material(TextureAtlas.f_118259_, new ResourceLocation("evilcraft", "entity/blook"));
    private final BookModel enchantmentBook;

    public RenderBlockEntityPurifier(BlockEntityRendererProvider.Context context) {
        this.enchantmentBook = new BookModel(context.m_173582_(ModelLayers.f_171271_));
    }

    public void render(BlockEntityPurifier tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack additionalItem = tile.getAdditionalItem();
        if (!additionalItem.m_41619_()) {
            if (additionalItem.m_41720_() == DisenchantPurifyAction.ALLOWED_BOOK.get() || additionalItem.m_41720_() == Items.f_42690_) {
                this.renderBook(tile, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, additionalItem, partialTicks);
            } else {
                this.renderAdditionalItem(tile, matrixStackIn, bufferIn, additionalItem, partialTicks);
            }
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
        if (!tile.getPurifyItem().m_41619_()) {
            this.renderItem(matrixStackIn, bufferIn, tile.getPurifyItem(), tile.getRandomRotation());
        }
        matrixStackIn.m_85849_();
        FluidStack fluid = tile.getTank().getFluid();
        RenderHelpers.renderFluidContext((FluidStack)fluid, (PoseStack)matrixStackIn, () -> {
            float height = (float)((double)fluid.getAmount() * 0.7 / (double)tile.getTank().getCapacity() + 0.23 + 0.01);
            int brightness = Math.max(combinedLightIn, fluid.getFluid().getAttributes().getLuminosity(fluid));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
            Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((BlockAndTintGetter)tile.m_58904_(), tile.m_58899_()));
            VertexConsumer vb = bufferIn.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_118414_().m_118330_()));
            Matrix4f matrix = matrixStackIn.m_85850_().m_85861_();
            vb.m_85982_(matrix, 0.0625f, height, 0.0625f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_85982_(matrix, 0.0625f, height, 0.9375f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_85982_(matrix, 0.9375f, height, 0.9375f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_85982_(matrix, 0.9375f, height, 0.0625f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
        });
    }

    private void renderItem(PoseStack matrixStackIn, MultiBufferSource bufferIn, ItemStack itemStack, float rotation) {
        matrixStackIn.m_85836_();
        if (itemStack.m_41720_() instanceof BlockItem) {
            matrixStackIn.m_85837_(1.0, (double)1.2f, 1.0);
            matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
        } else {
            matrixStackIn.m_85837_(1.0, (double)1.2f, 1.0);
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(25.0f));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(25.0f));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        }
        Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 0);
        matrixStackIn.m_85849_();
    }

    private void renderAdditionalItem(BlockEntityPurifier tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        matrixStackIn.m_85836_();
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        matrixStackIn.m_85837_(0.5, 0.75, 0.5);
        matrixStackIn.m_85837_(0.0, (double)(0.1f + Mth.m_14031_((float)(tick * 0.1f)) * 0.01f), 0.0);
        if (itemStack.m_41720_() instanceof BlockItem) {
            matrixStackIn.m_85837_(1.0, (double)0.675f, 1.0);
        }
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-rotation * 180.0f / (float)Math.PI));
        matrixStackIn.m_85837_(0.0, 0.5, 0.0);
        if (!(itemStack.m_41720_() instanceof BlockItem)) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(25.0f));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        }
        Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 0);
        matrixStackIn.m_85849_();
    }

    private void renderBook(BlockEntityPurifier tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.75, 0.5);
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        matrixStackIn.m_85837_(0.0, (double)(0.1f + Mth.m_14031_((float)(tick * 0.1f)) * 0.01f), 0.0);
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-rotation * 180.0f / (float)Math.PI));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(80.0f));
        float f3 = Mth.m_14179_((float)partialTickTime, (float)tile.oFlip, (float)tile.flip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)partialTickTime, (float)tile.oOpen, (float)tile.open);
        this.enchantmentBook.m_102292_(rotation, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
        Material material = itemStack.m_41720_() == DisenchantPurifyAction.ALLOWED_BOOK.get() ? TEXTURE_BLOOK : EnchantTableRenderer.f_112405_;
        VertexConsumer ivertexbuilder = material.m_119194_(bufferIn, RenderType::m_110446_);
        this.enchantmentBook.m_102316_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }
}

