/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;
import org.cyclops.evilcraft.core.client.model.ModelConfigurationRetextured;

public class ModelDisplayStandBaked
extends DynamicItemAndBlockModel {
    private static final Map<Direction, BlockModelRotation> ROTATIONS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)BlockModelRotation.X270_Y0).put((Object)Direction.SOUTH, (Object)BlockModelRotation.X90_Y0).put((Object)Direction.WEST, (Object)BlockModelRotation.X90_Y90).put((Object)Direction.EAST, (Object)BlockModelRotation.X270_Y90).put((Object)Direction.UP, (Object)BlockModelRotation.X180_Y0).put((Object)Direction.DOWN, (Object)BlockModelRotation.X0_Y0).build();
    private final SingleCache<ResourceLocation, BakedModel> modelCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ResourceLocation, BakedModel>(){

        public BakedModel getNewValue(ResourceLocation textureName) {
            return ModelDisplayStandBaked.bakeModel(new ModelConfigurationRetextured(ModelDisplayStandBaked.this.owner, textureName), ModelDisplayStandBaked.this.blockModel.m_111436_(), ModelDisplayStandBaked.this.transform, ItemOverrides.f_111734_, arg_0 -> ((AtlasSet)ForgeModelBakery.instance().getSpriteMap()).m_117971_(arg_0), new ResourceLocation("evilcraft", "dummy"));
        }

        public boolean isKeyEqual(ResourceLocation resourceLocation, ResourceLocation k1) {
            return resourceLocation.equals((Object)k1);
        }
    });
    private final BlockModel blockModel;
    private final BakedModel untexturedBakedModel;
    private final TextureAtlasSprite texture;
    private final IModelConfiguration owner;
    private final ModelState transform;

    public ModelDisplayStandBaked(BlockModel blockModel, BakedModel untexturedBakedModel, IModelConfiguration owner, ModelState transform) {
        super(true, false);
        this.blockModel = blockModel;
        this.untexturedBakedModel = untexturedBakedModel;
        this.owner = owner;
        this.transform = transform;
        this.texture = null;
    }

    public ModelDisplayStandBaked(BlockModel blockModel, BakedModel untexturedBakedModel, TextureAtlasSprite texture, boolean item, IModelConfiguration owner, ModelState transform) {
        super(false, item);
        this.blockModel = blockModel;
        this.untexturedBakedModel = untexturedBakedModel;
        this.texture = texture;
        this.owner = owner;
        this.transform = transform;
    }

    public TextureAtlasSprite m_6160_() {
        return this.texture;
    }

    protected BakedModel handleDisplayStandType(ItemStack displayStandType, boolean item) {
        if (displayStandType != null && !displayStandType.m_41619_()) {
            BlockState blockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)displayStandType);
            ResourceLocation textureName = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(blockState).m_6160_().m_118413_();
            return (BakedModel)this.modelCache.get((Object)textureName);
        }
        return this.untexturedBakedModel;
    }

    public static BakedModel bakeModel(IModelConfiguration modelConfiguration, List<BlockElement> blockParts, ModelState transform, ItemOverrides overrides, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation modelName) {
        TextureAtlasSprite particle = spriteGetter.apply(modelConfiguration.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(modelConfiguration, overrides).m_119528_(particle);
        for (BlockElement blockPart : blockParts) {
            for (Direction direction : blockPart.f_111310_.keySet()) {
                BlockElementFace blockPartFace = (BlockElementFace)blockPart.f_111310_.get(direction);
                String texture = blockPartFace.f_111356_;
                if (texture.charAt(0) == '#') {
                    texture = texture.substring(1);
                }
                TextureAtlasSprite sprite = spriteGetter.apply(modelConfiguration.resolveTexture(texture));
                if (blockPartFace.f_111354_ == null) {
                    builder.m_119526_(BlockModel.makeBakedQuad((BlockElement)blockPart, (BlockElementFace)blockPartFace, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)transform, (ResourceLocation)modelName));
                    continue;
                }
                builder.m_119530_(Direction.m_122384_((Matrix4f)transform.m_6189_().m_121104_(), (Direction)blockPartFace.f_111354_), BlockModel.makeBakedQuad((BlockElement)blockPart, (BlockElementFace)blockPartFace, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)transform, (ResourceLocation)modelName));
            }
        }
        return builder.m_119533_();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDisplayStand.class).map(tile -> {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            builder.withInitial(BlockDisplayStand.DIRECTION, (Object)tile.getDirection());
            builder.withInitial(BlockDisplayStand.TYPE, (Object)tile.getDisplayStandType());
            return builder.build();
        }).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public BakedModel handleBlockState(BlockState state, Direction side, Random rand, IModelData modelData) {
        return this.handleDisplayStandType((ItemStack)ModelHelpers.getSafeProperty((IModelData)modelData, BlockDisplayStand.TYPE, (Object)ItemStack.f_41583_), false);
    }

    public BakedModel handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        return this.handleDisplayStandType(RegistryEntries.BLOCK_DISPLAY_STAND.getDisplayStandType(itemStack), true);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.untexturedBakedModel.m_6840_(null, null, null).stream().map(quad -> new BakedQuad(quad.m_111303_(), quad.m_111305_(), quad.m_111306_(), this.texture, quad.m_111307_())).collect(Collectors.toList());
    }

    public boolean m_7547_() {
        return true;
    }

    public ItemTransforms m_7442_() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.handleDisplayStandType((ItemStack)ModelHelpers.getSafeProperty((IModelData)data, BlockDisplayStand.TYPE, (Object)ItemStack.f_41583_), false).m_6160_();
    }
}

