/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.network.packet.UpdateWorldSharedTankClientCachePacket;

public class WorldSharedTankCache {
    public static final int INTERPOLATION_TICK_OFFSET = 10;
    private static WorldSharedTankCache _instance = null;
    private Map<String, FluidStack> tankCache = Maps.newHashMap();
    private Map<String, UpdateWorldSharedTankClientCachePacket> packetBuffer = Maps.newHashMap();
    private int tick = 0;

    private WorldSharedTankCache() {
    }

    public void reset() {
        this.tankCache = Maps.newHashMap();
        this.packetBuffer = Maps.newHashMap();
        this.tick = 0;
    }

    public static WorldSharedTankCache getInstance() {
        if (_instance == null) {
            _instance = new WorldSharedTankCache();
        }
        return _instance;
    }

    protected String getMapID(String tankID) {
        return tankID + (MinecraftHelpers.isClientSide() ? "C" : "S");
    }

    protected String removeMapID(String mapID) {
        return mapID.substring(0, mapID.length() - 1);
    }

    public synchronized FluidStack getTankContent(String tankID) {
        FluidStack stack = this.tankCache.get(this.getMapID(tankID));
        return stack == null ? FluidStack.EMPTY : stack.copy();
    }

    protected static boolean shouldRefreshFluid(@Nullable FluidStack old, FluidStack newF) {
        return (old == null ? 0 : old.getAmount()) != newF.getAmount();
    }

    public synchronized void setTankContent(String tankID, FluidStack fluidStack) {
        String key = this.getMapID(tankID);
        boolean shouldRefresh = WorldSharedTankCache.shouldRefreshFluid(this.tankCache.get(key), fluidStack);
        if (fluidStack.isEmpty()) {
            this.tankCache.remove(key);
        } else if (shouldRefresh) {
            this.tankCache.put(key, fluidStack.copy());
        }
        if (!MinecraftHelpers.isClientSide() && shouldRefresh) {
            this.bufferPacket(tankID, new UpdateWorldSharedTankClientCachePacket(tankID, fluidStack));
        }
    }

    protected void bufferPacket(String tankID, UpdateWorldSharedTankClientCachePacket packet) {
        this.packetBuffer.put(tankID, packet);
    }

    public int getTickOffset() {
        return this.tick;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onTick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START && (event.type == TickEvent.Type.CLIENT || event.type == TickEvent.Type.SERVER)) {
            ++this.tick;
            if (event.side == LogicalSide.SERVER && this.getTickOffset() > 10) {
                Iterator<Map.Entry<String, UpdateWorldSharedTankClientCachePacket>> it = this.packetBuffer.entrySet().iterator();
                while (it.hasNext()) {
                    EvilCraft._instance.getPacketHandler().sendToAll((PacketBase)it.next().getValue());
                    it.remove();
                }
                this.tick = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!MinecraftHelpers.isClientSide()) {
            for (Map.Entry<String, FluidStack> entry : this.tankCache.entrySet()) {
                EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateWorldSharedTankClientCachePacket(this.removeMapID(entry.getKey()), entry.getValue()), (ServerPlayer)event.getPlayer());
            }
        }
    }

    public void readFromNBT(CompoundTag tag) {
        if (tag != null) {
            ListTag list = tag.m_128437_("tankCache", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag subTag = list.m_128728_(i);
                this.setTankContent(subTag.m_128461_("key"), FluidStack.loadFluidStackFromNBT((CompoundTag)subTag.m_128469_("value")));
            }
        }
    }

    public void writeToNBT(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<String, FluidStack> entry : this.tankCache.entrySet()) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128359_("key", this.removeMapID(entry.getKey()));
            CompoundTag fluidTag = new CompoundTag();
            entry.getValue().writeToNBT(fluidTag);
            subTag.m_128365_("value", (Tag)fluidTag);
            list.add((Object)subTag);
        }
        tag.m_128365_("tankCache", (Tag)list);
    }
}

