/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.InventoryHelpers;

public class NBTCraftingGrid
extends CraftingContainer {
    private static final String NBT_TAG_ROOT = "CraftingGridInventory";
    protected Player player;
    protected int itemIndex;
    protected InteractionHand hand;

    public NBTCraftingGrid(Player player, int itemIndex, InteractionHand hand, AbstractContainerMenu eventHandler) {
        super(eventHandler, 3, 3);
        ItemStack itemStack = InventoryHelpers.getItemFromIndex((Player)player, (int)itemIndex, (InteractionHand)hand);
        this.player = player;
        this.itemIndex = itemIndex;
        this.hand = hand;
        InventoryHelpers.validateNBTStorage((Container)this, (ItemStack)itemStack, (String)NBT_TAG_ROOT);
    }

    public void save() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex((Player)this.player, (int)this.itemIndex, (InteractionHand)this.hand);
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        this.writeToNBT(tag, NBT_TAG_ROOT);
        itemStack.m_41751_(tag);
    }

    protected void readFromNBT(CompoundTag data, String tagName) {
        InventoryHelpers.readFromNBT((Container)this, (CompoundTag)data, (String)tagName);
    }

    protected void writeToNBT(CompoundTag data, String tagName) {
        InventoryHelpers.writeToNBT((Container)this, (CompoundTag)data, (String)tagName);
    }
}

