/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemBloodContainer
extends DamageIndicatedItemFluidContainer {
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    public ItemBloodContainer(Item.Properties builder, int capacity) {
        super(builder, capacity, () -> RegistryEntries.FLUID_BLOOD);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        FluidStack drained = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        boolean hasBucket = !drained.isEmpty() && drained.getAmount() == 1000;
        boolean hasSpace = fluidStack.isEmpty() || fluidStack.getAmount() + 1000 <= fluidHandler.getCapacity();
        BlockHitResult movingobjectpositionDrain = ItemBloodContainer.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockHitResult movingobjectpositionFill = ItemBloodContainer.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            BlockPos blockPos;
            BlockState blockState;
            if (this.isPickupFluids() && movingobjectpositionFill.m_6662_() == HitResult.Type.BLOCK && (blockState = world.m_8055_(blockPos = movingobjectpositionFill.m_82425_())).m_60734_() instanceof LiquidBlock && ((LiquidBlock)blockState.m_60734_()).getFluid() == this.getFluid() && (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                if (hasSpace) {
                    world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                    fluidHandler.fill(new FluidStack(this.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return MinecraftHelpers.successAction((Object)itemStack);
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.m_6662_() == HitResult.Type.BLOCK) {
                blockPos = movingobjectpositionFill.m_82425_();
                Direction direction = movingobjectpositionDrain.m_82434_();
                if (this.tryPlaceContainedLiquid(world, blockPos = blockPos.m_141952_(direction.m_122436_()), true)) {
                    fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    return MinecraftHelpers.successAction((Object)itemStack);
                }
            }
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    private boolean tryPlaceContainedLiquid(Level world, BlockPos blockPos, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        BlockState blockState = world.m_8055_(blockPos);
        Material material = blockState.m_60767_();
        if (!world.m_46859_(blockPos) && material.m_76333_()) {
            return false;
        }
        if (!(world.f_46443_ || material.m_76333_() || material.m_76332_())) {
            world.m_46961_(blockPos, true);
        }
        world.m_7731_(blockPos, this.getFluid().getAttributes().getBlock((BlockAndTintGetter)world, blockPos, this.getFluid().m_76145_()), 3);
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, Player player, IFluidHandler.FluidAction action) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        FluidStack drained = FluidStack.EMPTY;
        while (it.hasNext() && amount > 0) {
            FluidStack thisDrained;
            FluidStack totalFluid;
            ItemStack current = it.next();
            IFluidHandler containerItem = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)current).orElse(null);
            if (current.m_41619_() || current == itemStack || containerItem == null || (totalFluid = FluidUtil.getFluidContained((ItemStack)current).orElse(FluidStack.EMPTY)).isEmpty() || totalFluid.getFluid() != fluid || (thisDrained = containerItem.drain(amount, action)).isEmpty() || thisDrained.getFluid() != fluid) continue;
            if (drained.isEmpty()) {
                drained = thisDrained;
            } else {
                drained.setAmount(drained.getAmount() + thisDrained.getAmount());
            }
            amount -= drained.getAmount();
        }
        if (!drained.isEmpty() && drained.isEmpty()) {
            drained = FluidStack.EMPTY;
        }
        return drained;
    }

    public boolean canConsume(int amount, ItemStack itemStack, @Nullable Player player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = FluidUtil.getFluidContained((ItemStack)itemStack).map(FluidStack::getAmount).orElse(0);
        return player != null && !this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public FluidStack consume(int amount, ItemStack itemStack, @Nullable Player player) {
        FluidStack otherDrained;
        IFluidHandler.FluidAction fluidAction;
        IFluidHandler.FluidAction fluidAction2 = fluidAction = player == null || !player.m_7500_() && !player.f_19853_.f_46443_ ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE;
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElseGet(null)).drain(amount, fluidAction);
        if (!drained.isEmpty() && drained.getAmount() == amount) {
            return drained;
        }
        int drainedAmount = drained.getAmount();
        int toDrain = amount - drainedAmount;
        FluidStack fluidStack = otherDrained = player == null ? FluidStack.EMPTY : this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, fluidAction);
        if (otherDrained.isEmpty()) {
            return drained;
        }
        otherDrained.setAmount(otherDrained.getAmount() + drainedAmount);
        return otherDrained;
    }
}

