/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.monster;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityNoMob
extends PathfinderMob {
    public EntityNoMob(EntityType<? extends EntityNoMob> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void m_8107_() {
        this.m_21203_();
        this.idle();
        super.m_8107_();
    }

    protected void idle() {
        float f = this.m_6073_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12042_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12041_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12039_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12038_;
    }

    protected SoundEvent m_5896_(int heightIn) {
        return heightIn > 4 ? SoundEvents.f_12037_ : SoundEvents.f_12040_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.5f - worldIn.m_46863_(pos);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.m_45517_(LightLayer.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.m_6018_().m_46470_() ? worldIn.m_46849_(pos, 10) : worldIn.m_46803_(pos);
        return i <= randomIn.nextInt(8);
    }

    public static boolean canMonsterSpawnInLight(EntityType<? extends Monster> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && EntityNoMob.isValidLightLevel(worldIn, pos, randomIn) && EntityNoMob.m_21400_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public static boolean canMonsterSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && EntityNoMob.m_21400_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public static AttributeSupplier.Builder createMonsterAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22281_);
    }

    protected boolean m_6149_() {
        return true;
    }

    protected boolean m_6125_() {
        return true;
    }

    public boolean isPreventingPlayerRest(Player p_230292_1_) {
        return true;
    }

    public ItemStack m_6298_(ItemStack shootable) {
        if (shootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)shootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack;
        }
        return ItemStack.f_41583_;
    }
}

