/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public abstract class RecipeSerializerEnvironmentalAccumulatorAbstract<T extends RecipeEnvironmentalAccumulator>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<T> {
    protected WeatherType getWeatherType(String type) throws JsonSyntaxException {
        WeatherType weather = WeatherType.valueOf(type);
        if (weather == null) {
            throw new JsonSyntaxException(String.format("Could not found the weather '%s'", type));
        }
        return weather;
    }

    protected abstract T createRecipe(ResourceLocation var1, Ingredient var2, WeatherType var3, ItemStack var4, WeatherType var5, int var6, int var7, float var8);

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        WeatherType inputWeather = this.getWeatherType(GsonHelper.m_13906_((JsonObject)json, (String)"weather"));
        ItemStack outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false);
        WeatherType outputWeather = this.getWeatherType(GsonHelper.m_13906_((JsonObject)result, (String)"weather"));
        int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)-1);
        int cooldownTime = GsonHelper.m_13824_((JsonObject)json, (String)"cooldownTime", (int)-1);
        float processingSpeed = GsonHelper.m_13820_((JsonObject)json, (String)"processingSpeed", (float)-1.0f);
        return this.createRecipe(recipeId, inputIngredient, inputWeather, outputItemStack, outputWeather, duration, cooldownTime, processingSpeed);
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        WeatherType inputWeather = this.getWeatherType(buffer.m_130136_(20));
        ItemStack outputItemStack = buffer.m_130267_();
        WeatherType outputWeather = this.getWeatherType(buffer.m_130136_(20));
        int duration = buffer.m_130242_();
        int cooldownTime = buffer.m_130242_();
        float processingSpeed = buffer.readFloat();
        return this.createRecipe(recipeId, inputIngredient, inputWeather, outputItemStack, outputWeather, duration, cooldownTime, processingSpeed);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeEnvironmentalAccumulator recipe) {
        recipe.getInputIngredient().m_43923_(buffer);
        buffer.m_130070_(recipe.getInputWeather().toString().toUpperCase(Locale.ENGLISH));
        buffer.m_130055_(recipe.getOutputItem());
        buffer.m_130070_(recipe.getOutputWeather().toString().toUpperCase(Locale.ENGLISH));
        buffer.m_130130_(recipe.getDuration());
        buffer.m_130130_(recipe.getCooldownTime());
        buffer.writeFloat(recipe.getProcessingSpeed());
    }
}

