/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import java.util.Random;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.DamageableItemRepairAction;

public class EnchantmentBreaking
extends Enchantment {
    public EnchantmentBreaking() {
        super(Enchantment.Rarity.COMMON, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        DamageableItemRepairAction.BAD_ENCHANTS.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakingEvent(LivingAttackEvent event) {
        ItemStack itemStack;
        int enchantmentListID;
        LivingEntity entity;
        InteractionHand hand;
        if (!event.getEntity().m_20193_().m_5776_() && event.getSource().m_7639_() instanceof LivingEntity && (hand = (entity = (LivingEntity)event.getSource().m_7639_()).m_7655_()) != null && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = entity.m_21120_(hand)), (Enchantment)this)) > -1) {
            EnchantmentBreaking.amplifyDamage(itemStack, enchantmentListID, new Random());
            entity.m_21008_(hand, itemStack);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakingEvent(BlockEvent.BreakEvent event) {
        InteractionHand hand;
        if (!event.getPlayer().f_19853_.m_5776_() && (hand = event.getPlayer().m_7655_()) != null) {
            int i = EnchantmentHelpers.doesEnchantApply((ItemStack)event.getPlayer().m_21120_(hand), (Enchantment)this);
            ItemStack itemStack = event.getPlayer().m_21120_(hand);
            EnchantmentBreaking.amplifyDamage(itemStack, i, new Random());
            event.getPlayer().m_21008_(hand, itemStack);
        }
    }

    public int m_6183_(int level) {
        return 1 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6589_() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public static void amplifyDamage(ItemStack itemStack, int enchantmentListID, Random random) {
        if (enchantmentListID > -1) {
            int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)itemStack, (int)enchantmentListID);
            int newDamage = itemStack.m_41773_() + 2;
            if (!(random.nextFloat() < 0.6f) && random.nextInt(level + 1) > 0 && newDamage <= itemStack.m_41776_()) {
                itemStack.m_41721_(newDamage);
            }
        }
    }
}

