/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockGemStoneTorchConfig;
import org.cyclops.evilcraft.client.particle.ParticleDarkSmokeData;
import org.cyclops.evilcraft.core.monster.EntityNoMob;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritSyncedData;
import org.cyclops.evilcraft.item.ItemBurningGemStone;
import org.cyclops.evilcraft.item.ItemSpectralGlasses;
import org.cyclops.evilcraft.item.ItemVengeanceRing;

public class EntityVengeanceSpirit
extends EntityNoMob {
    private static final Set<String> IMC_BLACKLIST;
    public static final int REMAININGLIFE_MIN = 250;
    public static final int REMAININGLIFE_MAX = 1000;
    public static final EntityDataAccessor<String> WATCHERID_INNER;
    public static final EntityDataAccessor<Integer> WATCHERID_REMAININGLIFE;
    public static final EntityDataAccessor<Integer> WATCHERID_FROZENDURATION;
    public static final EntityDataAccessor<Integer> WATCHERID_GLOBALVENGEANCE;
    public static final EntityDataAccessor<String> WATCHERID_VENGEANCEPLAYERS;
    public static final EntityDataAccessor<Integer> WATCHERID_ISSWARM;
    public static final EntityDataAccessor<Integer> WATCHERID_SWARMTIER;
    public static final EntityDataAccessor<Integer> WATCHERID_BUILDUP;
    public static final EntityDataAccessor<String> WATCHERID_PLAYERID;
    public static final EntityDataAccessor<String> WATCHERID_PLAYERNAME;
    private EntityVengeanceSpiritSyncedData data;
    private Mob innerEntity = null;
    @Nullable
    private EntityType<?> preferredInnerEntity;
    private final Set<ServerPlayer> entanglingPlayers = Sets.newHashSet();

    public EntityVengeanceSpirit(EntityType<? extends EntityVengeanceSpirit> type, Level level) {
        this(type, level, null);
    }

    public EntityVengeanceSpirit(Level level) {
        this(RegistryEntries.ENTITY_VENGEANCE_SPIRIT, level, null);
    }

    public EntityVengeanceSpirit(EntityType<? extends EntityVengeanceSpirit> type, Level level, @Nullable EntityType<?> preferredInnerEntity) {
        super(type, level);
        this.preferredInnerEntity = preferredInnerEntity;
        this.f_19793_ = 5.0f;
        this.f_19850_ = false;
        float damage = 0.5f;
        int remainingLife = Mth.m_14072_((Random)level.f_46441_, (int)250, (int)1000);
        if (this.isSwarm()) {
            damage = (float)((double)damage + 0.5 * (double)this.getSwarmTier());
            remainingLife += 750 * this.getSwarmTier();
        }
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, damage));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.setRemainingLife(remainingLife);
        this.setFrozenDuration(0);
    }

    public double m_21133_(Attribute attribute) {
        if (attribute == Attributes.f_22279_) {
            double speed = 0.25;
            if (this.isSwarm()) {
                speed += 0.125 * (double)this.getSwarmTier();
            }
            return speed;
        }
        return super.m_21133_(attribute);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void vengeanceEvent(LivingDeathEvent event) {
        if (event.getEntityLiving() != null) {
            Level level = event.getEntityLiving().f_19853_;
            boolean directToPlayer = EntityVengeanceSpirit.shouldDirectSpiritToPlayer(event);
            if (!level.m_5776_() && level.m_46791_() != Difficulty.PEACEFUL && EntityVengeanceSpirit.canSustain(event.getEntityLiving()) && (directToPlayer || EntityVengeanceSpirit.canSpawnNew(level, event.getEntityLiving().m_142538_()))) {
                EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(level);
                spirit.setInnerEntity(event.getEntityLiving());
                spirit.m_20359_((Entity)event.getEntityLiving());
                level.m_7967_((Entity)spirit);
                if (directToPlayer) {
                    Player player = (Player)event.getSource().m_7640_();
                    spirit.setBuildupDuration(60);
                    spirit.setGlobalVengeance(true);
                    spirit.m_6710_((LivingEntity)player);
                }
            }
        }
    }

    private static boolean shouldDirectSpiritToPlayer(LivingDeathEvent event) {
        if (event.getSource().m_7640_() instanceof Player) {
            Player player = (Player)event.getSource().m_7640_();
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            while (it.hasNext()) {
                ItemStack itemStack = it.next();
                if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemVengeanceRing)) continue;
                return true;
            }
        }
        return false;
    }

    public void m_8097_() {
        super.m_8097_();
        this.data = this.preferredInnerEntity == null ? new EntityVengeanceSpiritSyncedData(this.f_19804_, EntityVengeanceSpiritData.getRandomInnerEntity(this.f_19796_)) : new EntityVengeanceSpiritSyncedData(this.f_19804_, this.preferredInnerEntity);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.data.writeNBT(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.data.readNBT(tag);
    }

    public ResourceLocation m_7582_() {
        return new ResourceLocation("evilcraft", "entities/" + this.m_6095_().getRegistryName().m_135815_());
    }

    public float m_6100_() {
        return super.m_6100_() / 3.0f;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6673_(DamageSource damageSource) {
        return !(damageSource instanceof ExtendedDamageSource.VengeanceBeamDamageSource) && damageSource != DamageSource.f_19317_;
    }

    public boolean m_7327_(Entity entity) {
        Player player;
        if (this.getBuildupDuration() > 0) {
            return false;
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (entity instanceof Player && ItemBurningGemStone.damageForPlayer(player = (Player)entity, this.isSwarm() ? this.getSwarmTier() : 0, false)) {
            entity.m_20334_((double)(-Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * 0.01f), 0.025, (double)(Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * 0.01f));
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 0.1f);
            return false;
        }
        return super.m_7327_(entity);
    }

    protected void m_7625_(DamageSource damageSource, boolean fromPlayer) {
        ResourceLocation deathLootTable;
        super.m_7625_(damageSource, fromPlayer);
        Mob innerEntity = this.getInnerEntity();
        if (innerEntity != null && damageSource != DamageSource.f_19317_ && (deathLootTable = innerEntity.m_5743_()) != null) {
            LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(deathLootTable);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78972_(LootContextParams.f_81455_, (Object)innerEntity).m_78972_(LootContextParams.f_81460_, (Object)new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_())).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.f_19318_).m_78984_(LootContextParams.f_81458_, null).m_78984_(LootContextParams.f_81459_, null);
            if (fromPlayer && this.f_20888_ != null) {
                lootcontext$builder = lootcontext$builder.m_78972_(LootContextParams.f_81456_, (Object)this.f_20888_).m_78963_(this.f_20888_.m_36336_());
            }
            for (ItemStack itemstack : loottable.m_79129_(lootcontext$builder.m_78975_(LootContextParamSets.f_81415_))) {
                this.m_5552_(itemstack, 0.0f);
            }
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        if (this.f_19853_.m_5776_() && this.isVisible()) {
            this.spawnSmoke();
            this.m_5496_(this.m_5592_(), 0.1f + this.f_19853_.f_46441_.nextFloat() * 0.9f, 0.1f + this.f_19853_.f_46441_.nextFloat() * 0.9f);
        }
    }

    public boolean m_6107_() {
        return this.isFrozen() || this.getBuildupDuration() > 0;
    }

    @Override
    public void m_8107_() {
        int buildupDuration;
        super.m_8107_();
        if (this.isVisible()) {
            if (this.innerEntity != null) {
                this.innerEntity.f_20919_ = this.f_20919_;
                this.innerEntity.m_6710_(this.m_5448_());
                this.innerEntity.f_20916_ = this.f_20916_;
                this.innerEntity.m_146926_(this.m_146909_());
                this.innerEntity.m_146922_(this.m_146908_());
                this.innerEntity.f_19860_ = this.f_19860_;
                this.innerEntity.f_19859_ = this.f_19859_;
                this.innerEntity.f_20883_ = this.f_20883_;
                this.innerEntity.f_20884_ = this.f_20884_;
                this.innerEntity.f_20885_ = this.f_20885_;
                this.innerEntity.f_20886_ = this.f_20886_;
            }
            if (this.f_19853_.m_5776_()) {
                this.spawnSmoke();
                if (this.isSwarm()) {
                    this.spawnSwarmParticles();
                }
            }
        }
        if ((buildupDuration = this.getBuildupDuration()) > 0) {
            this.setBuildupDuration(buildupDuration - 1);
        }
        if (this.isFrozen()) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.addFrozenDuration(-1);
        } else {
            this.setRemainingLife(this.getRemainingLife() - 1);
            if (this.getRemainingLife() <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSmoke() {
        EntityDimensions size = this.m_6972_(this.m_20089_());
        int numParticles = this.f_19796_.nextInt(5);
        if (!this.m_6084_()) {
            numParticles *= 10;
        }
        float clearRange = size.f_20377_;
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.m_20185_() - (double)(size.f_20377_ / 2.0f) + (double)(size.f_20377_ * this.f_19796_.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(size.f_20377_ / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(size.f_20377_ / 2.0f);
            }
            double particleY = this.m_20186_() + (double)(size.f_20378_ * this.f_19796_.nextFloat());
            double particleZ = this.m_20189_() - (double)(size.f_20377_ / 2.0f) + (double)(size.f_20377_ * this.f_19796_.nextFloat());
            if (particleZ < (double)clearRange && particleZ >= 0.0) {
                particleZ += (double)(size.f_20377_ / 2.0f);
            }
            if (particleZ > (double)(-clearRange) && particleZ <= 0.0) {
                particleZ -= (double)(size.f_20377_ / 2.0f);
            }
            float particleMotionX = (-0.5f + this.f_19796_.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.f_19796_.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.f_19796_.nextFloat()) * 0.05f;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleDarkSmokeData(!this.m_6084_()), false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSwarmParticles() {
        EntityDimensions size = this.m_6972_(this.m_20089_());
        int numParticles = 5 * (this.f_19796_.nextInt((this.getSwarmTier() << 1) + 1) + 1);
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.m_20185_() - (double)(size.f_20377_ / 2.0f) + (double)(size.f_20377_ * this.f_19796_.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(size.f_20377_ / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(size.f_20377_ / 2.0f);
            }
            double particleY = this.m_20186_() + (double)(size.f_20378_ * this.f_19796_.nextFloat());
            double particleZ = this.m_20189_() - (double)(size.f_20377_ / 2.0f) + (double)(size.f_20377_ * this.f_19796_.nextFloat());
            float particleMotionX = (-0.5f + this.f_19796_.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.f_19796_.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.f_19796_.nextFloat()) * 0.05f;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)RegistryEntries.PARTICLE_DEGRADE, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public void m_5496_(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn != null && this.isVisible() && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), soundIn, this.m_5720_(), volume, pitch, true);
        }
    }

    public boolean isVisible() {
        return this.f_19853_.m_5776_() && (this.isAlternativelyVisible() || this.isClientVisible());
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isClientVisible() {
        if (this.isEnabledVengeance((Player)Minecraft.m_91087_().f_91074_)) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator((Player)Minecraft.m_91087_().f_91074_);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemSpectralGlasses)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlternativelyVisible() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return EntityVengeanceSpiritConfig.alwaysVisibleInCreative && player != null && player.m_7500_();
    }

    protected void m_6138_() {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
        this.setGlobalVengeance(true);
    }

    public boolean m_142582_(Entity entity) {
        if (entity instanceof Player) {
            return this.isEnabledVengeance((Player)entity);
        }
        return super.m_142582_(entity);
    }

    public boolean isEnabledVengeance(Player player) {
        return this.isGlobalVengeance() || player != null && ArrayUtils.contains((Object[])this.getVengeancePlayers(), (Object)player.m_7755_());
    }

    public void setEnabledVengeance(Player player, boolean enabled) {
        Object[] players = this.getVengeancePlayers();
        int index = ArrayUtils.indexOf((Object[])players, (Object)player.m_5446_().getString());
        if (enabled && index == -1) {
            players = (String[])ArrayUtils.add((Object[])players, (Object)player.m_7755_().getString());
        } else if (!enabled && index != -1) {
            players = (String[])ArrayUtils.remove((Object[])players, (int)index);
        }
        this.setVengeancePlayers((String[])players);
    }

    public boolean isPlayer() {
        return this.containsPlayer();
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.isSwarm()) {
            return EntityDimensions.m_20395_((float)(this.getSwarmTier() / 3 + 1), (float)(this.getSwarmTier() / 2 + 1));
        }
        Mob innerEntity = this.getInnerEntity();
        if (innerEntity != null) {
            return innerEntity.m_6972_(poseIn);
        }
        return super.m_6972_(poseIn);
    }

    @Nullable
    public Mob getInnerEntity() {
        if (this.isSwarm()) {
            return null;
        }
        EntityType<?> entityType = this.data.getInnerEntityType();
        if (this.innerEntity != null && entityType != null && entityType == this.innerEntity.m_6095_()) {
            return this.innerEntity;
        }
        try {
            Entity entity;
            if (entityType != RegistryEntries.ENTITY_VENGEANCE_SPIRIT && EntityVengeanceSpirit.canSustain((LivingEntity)(entity = entityType.m_20615_(this.f_19853_)))) {
                this.innerEntity = (Mob)entity;
                return this.innerEntity;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void setInnerEntity(LivingEntity innerEntity) {
        if (innerEntity instanceof Player) {
            this.setPlayerId(((Player)innerEntity).m_36316_().getId().toString());
            this.setPlayerName(((Player)innerEntity).m_36316_().getName());
            this.data.setInnerEntityType(EntityType.f_20501_);
        } else {
            this.data.setInnerEntityType(innerEntity.m_6095_());
        }
    }

    public static boolean canSustain(LivingEntity entityLiving) {
        String entityName = entityLiving.m_6095_().getRegistryName().toString();
        for (String blacklistedRegex : EntityVengeanceSpiritConfig.entityBlacklist) {
            if (!entityName.matches(blacklistedRegex)) continue;
            return false;
        }
        for (String blacklistedRegex : IMC_BLACKLIST) {
            if (!entityName.matches(blacklistedRegex)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpawnNew(Level level, BlockPos blockPos) {
        int area = EntityVengeanceSpiritConfig.spawnLimitArea;
        int threshold = EntityVengeanceSpiritConfig.spawnLimit;
        AABB box = new AABB((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()).m_82377_((double)area, (double)area, (double)area);
        List spirits = level.m_45976_(EntityVengeanceSpirit.class, box);
        if (spirits.size() >= threshold) {
            return false;
        }
        return (Boolean)WorldHelpers.foldArea((LevelAccessor)level, (int)BlockGemStoneTorchConfig.area, (BlockPos)blockPos, (input, level1, blockPos1) -> input != false && !BlockTags.m_13115_().m_13404_(new ResourceLocation("evilcraft:vengeance_spirit_blocker")).m_8110_((Object)level1.m_8055_(blockPos1).m_60734_()), (Object)true);
    }

    public void onHit(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        this.addFrozenDuration(this.f_19853_.f_46441_.nextInt(4) + 3);
        if (this.f_19853_.m_5776_()) {
            this.showBurstParticles(hitX, hitY, hitZ, impactMotionX, impactMotionY, impactMotionZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showBurstParticles(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        for (int i = 0; i < this.f_19853_.f_46441_.nextInt(5); ++i) {
            float scale = 0.04f - this.f_19796_.nextFloat() * 0.02f;
            float red = this.f_19796_.nextFloat() * 0.2f + 0.3f;
            float green = this.f_19796_.nextFloat() * 0.2f + 0.3f;
            float blue = this.f_19796_.nextFloat() * 0.01f;
            float ageMultiplier = (float)(this.f_19796_.nextDouble() * 0.5 + 3.0);
            double dx = 0.1 - this.f_19796_.nextDouble() * 0.2 - impactMotionX * 0.1;
            double dy = 0.1 - this.f_19796_.nextDouble() * 0.2 - impactMotionY * 0.1;
            double dz = 0.1 - this.f_19796_.nextDouble() * 0.2 - impactMotionZ * 0.1;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, hitX, hitY, hitZ, dx, dy, dz);
        }
    }

    public static EntityVengeanceSpirit spawnRandom(Level level, BlockPos blockPos, int area) {
        EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(level);
        int baseDistance = 5;
        for (int attempts = 50; EntityVengeanceSpirit.canSpawnNew(level, blockPos) && attempts > 0; --attempts) {
            BlockPos spawnPos = blockPos.m_142082_(Mth.m_14072_((Random)level.f_46441_, (int)baseDistance, (int)(baseDistance + area)) * Mth.m_14072_((Random)level.f_46441_, (int)-1, (int)1), Mth.m_14072_((Random)level.f_46441_, (int)0, (int)3) * Mth.m_14072_((Random)level.f_46441_, (int)-1, (int)1), Mth.m_14072_((Random)level.f_46441_, (int)baseDistance, (int)(baseDistance + area)) * Mth.m_14072_((Random)level.f_46441_, (int)-1, (int)1));
            if (!BlockHelpers.doesBlockHaveSolidTopSurface((LevelReader)level, (BlockPos)spawnPos.m_142082_(0, -1, 0))) continue;
            spirit.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.5, (double)spawnPos.m_123343_() + 0.5);
            if (level.m_45786_((Entity)spirit) || level.m_46855_(spirit.m_142469_())) continue;
            level.m_7967_((Entity)spirit);
            return spirit;
        }
        return null;
    }

    @Override
    public SoundEvent m_5592_() {
        if (this.getInnerEntity() != null) {
            return this.getInnerEntity().m_5592_();
        }
        return EvilCraftSoundEvents.mob_vengeancespirit_death;
    }

    public SoundEvent m_7515_() {
        Mob entity = this.getInnerEntity();
        if (entity != null && entity instanceof Mob) {
            return this.getInnerEntity().m_7515_();
        }
        return EvilCraftSoundEvents.mob_vengeancespirit_ambient;
    }

    public static void addToBlacklistIMC(String entityName) {
        IMC_BLACKLIST.add(entityName);
        EvilCraft.clog("Added entity name " + entityName + " to the spirit blacklist.", org.apache.logging.log4j.Level.TRACE);
    }

    public boolean m_19943_(Tag<Fluid> fluidTag, double p_210500_2_) {
        return this.f_19798_;
    }

    public boolean m_6090_() {
        return true;
    }

    public static EntityVengeanceSpirit fromNBT(Level level, CompoundTag spiritTag) {
        EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(level);
        spirit.m_7378_(spiritTag);
        return spirit;
    }

    public void addEntanglingPlayer(ServerPlayer player) {
        this.entanglingPlayers.add(player);
    }

    public Set<ServerPlayer> getEntanglingPlayers() {
        return this.entanglingPlayers;
    }

    public EntityVengeanceSpiritSyncedData getData() {
        return this.data;
    }

    public void register(SynchedEntityData dataManager) {
        this.getData().register(dataManager);
    }

    public EntityType<?> getInnerEntityType() {
        return this.getData().getInnerEntityType();
    }

    public void setInnerEntityType(EntityType<?> innerEntityType) {
        this.getData().setInnerEntityType(innerEntityType);
    }

    public int getRemainingLife() {
        return this.getData().getRemainingLife();
    }

    public void setRemainingLife(int remainingLife) {
        this.getData().setRemainingLife(remainingLife);
    }

    public int getFrozenDuration() {
        return this.getData().getFrozenDuration();
    }

    public void setFrozenDuration(int frozenDuration) {
        this.getData().setFrozenDuration(frozenDuration);
    }

    public String getPlayerId() {
        return this.getData().getPlayerId();
    }

    public void setPlayerId(String playerId) {
        this.getData().setPlayerId(playerId);
    }

    public String getPlayerName() {
        return this.getData().getPlayerName();
    }

    public void setPlayerName(String playerName) {
        this.getData().setPlayerName(playerName);
    }

    public boolean isSwarm() {
        return this.getData().isSwarm();
    }

    public void setSwarm(boolean isSwarm) {
        this.getData().setSwarm(isSwarm);
    }

    public int getSwarmTier() {
        return this.getData().getSwarmTier();
    }

    public void setSwarmTier(int swarmTier) {
        this.getData().setSwarmTier(swarmTier);
    }

    public boolean isGlobalVengeance() {
        return this.getData().isGlobalVengeance();
    }

    public void setGlobalVengeance(boolean globalVengeance) {
        this.getData().setGlobalVengeance(globalVengeance);
    }

    public String[] getVengeancePlayers() {
        return this.getData().getVengeancePlayers();
    }

    public void setVengeancePlayers(String[] vengeancePlayers) {
        this.getData().setVengeancePlayers(vengeancePlayers);
    }

    public boolean isFrozen() {
        return this.getData().isFrozen();
    }

    public void addFrozenDuration(int amount) {
        this.getData().addFrozenDuration(amount);
    }

    public boolean containsPlayer() {
        return this.getData().containsPlayer();
    }

    public boolean hasInnerEntity() {
        return this.getData().hasInnerEntity();
    }

    public void setRandomSwarmTier(Random random) {
        this.getData().setRandomSwarmTier(random);
    }

    public void readNBT(CompoundTag tag) {
        this.getData().readNBT(tag);
    }

    public CompoundTag writeNBT(CompoundTag tag) {
        return this.getData().writeNBT(tag);
    }

    public UUID getPlayerUUID() {
        return this.getData().getPlayerUUID();
    }

    public int getBuildupDuration() {
        return this.getData().getBuildupDuration();
    }

    public void setBuildupDuration(int buildupDuration) {
        this.getData().setBuildupDuration(buildupDuration);
    }

    static {
        MinecraftForge.EVENT_BUS.register(EntityVengeanceSpirit.class);
        IMC_BLACKLIST = Sets.newHashSet();
        WATCHERID_INNER = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        WATCHERID_REMAININGLIFE = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        WATCHERID_FROZENDURATION = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        WATCHERID_GLOBALVENGEANCE = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        WATCHERID_VENGEANCEPLAYERS = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        WATCHERID_ISSWARM = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        WATCHERID_SWARMTIER = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        WATCHERID_BUILDUP = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        WATCHERID_PLAYERID = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        WATCHERID_PLAYERNAME = SynchedEntityData.m_135353_(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

