/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityVengeanceSpiritData {
    private static final int SWARM_TIERS = 5;
    private static String NBTKEY_INNER_ENTITY = "innerEntity";
    private static String NBTKEY_REMAINING_LIFE = "remainingLife";
    private static String NBTKEY_FROZEN_DURATION = "frozenDuration";
    private static String NBTKEY_IS_SWARM = "isSwarm";
    private static String NBTKEY_SWARM_TIER = "swarmTier";
    private static String NBTKEY_BUILDUP_DURATION = "buildupDuration";
    private static String NBTKEY_PLAYER_ID = "playerId";
    private static String NBTKEY_PLAYER_NAME = "playerName";
    public static String NBTKEY_INNER_SPIRIT = NBTKEY_INNER_ENTITY;
    @Nullable
    private EntityType<?> innerEntityType;
    private int remainingLife;
    private int frozenDuration;
    private boolean isSwarm;
    private int swarmTier;
    private int buildupDuration;
    private String playerId;
    private String playerName;

    public EntityVengeanceSpiritData() {
        this(null, 0);
    }

    public EntityVengeanceSpiritData(EntityType<?> innerEntityType) {
        this(innerEntityType, 0);
    }

    public EntityVengeanceSpiritData(EntityType<?> innerEntityType, int swarmTier) {
        this.innerEntityType = innerEntityType;
        this.swarmTier = swarmTier;
        this.playerId = "";
        this.playerName = "";
    }

    public boolean isFrozen() {
        return this.getFrozenDuration() > 0;
    }

    public void addFrozenDuration(int amount) {
        this.setFrozenDuration(this.getFrozenDuration() + amount);
    }

    public boolean containsPlayer() {
        return this.getPlayerId() != null && !this.getPlayerId().isEmpty();
    }

    public boolean hasInnerEntity() {
        return this.getInnerEntityType() != null;
    }

    public void setRandomSwarmTier(Random random) {
        this.setSwarmTier(EntityVengeanceSpiritData.getRandomSwarmTier(random));
    }

    public void readNBT(CompoundTag tag) {
        this.setInnerEntityType((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.m_128461_(NBTKEY_INNER_ENTITY))));
        this.setRemainingLife(tag.m_128451_(NBTKEY_REMAINING_LIFE));
        this.setFrozenDuration(tag.m_128451_(NBTKEY_FROZEN_DURATION));
        this.setSwarm(tag.m_128471_(NBTKEY_IS_SWARM));
        this.setSwarmTier(tag.m_128451_(NBTKEY_SWARM_TIER));
        this.setBuildupDuration(tag.m_128451_(NBTKEY_BUILDUP_DURATION));
        this.setPlayerId(tag.m_128461_(NBTKEY_PLAYER_ID));
        this.setPlayerName(tag.m_128461_(NBTKEY_PLAYER_NAME));
    }

    public CompoundTag writeNBT(CompoundTag tag) {
        if (this.getInnerEntityType() != null) {
            tag.m_128359_(NBTKEY_INNER_ENTITY, this.getInnerEntityType().getRegistryName().toString());
        }
        tag.m_128405_(NBTKEY_REMAINING_LIFE, this.getRemainingLife());
        tag.m_128405_(NBTKEY_FROZEN_DURATION, this.getFrozenDuration());
        tag.m_128379_(NBTKEY_IS_SWARM, this.isSwarm());
        tag.m_128405_(NBTKEY_SWARM_TIER, this.getSwarmTier());
        tag.m_128405_(NBTKEY_BUILDUP_DURATION, this.getBuildupDuration());
        tag.m_128359_(NBTKEY_PLAYER_ID, this.getPlayerId());
        tag.m_128359_(NBTKEY_PLAYER_NAME, this.getPlayerName());
        return tag;
    }

    public UUID getPlayerUUID() {
        try {
            return UUID.fromString(this.getPlayerId());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static EntityType<?> getRandomInnerEntity(Random rand) {
        List entities = ForgeRegistries.ENTITIES.getValues().stream().filter(e -> e.m_20674_() == MobCategory.MONSTER).collect(Collectors.toList());
        return (EntityType)entities.get(rand.nextInt(entities.size()));
    }

    public static int getRandomSwarmTier(Random rand) {
        return rand.nextInt(5);
    }

    @Nullable
    public static EntityType<?> getSpiritType(@Nullable CompoundTag tag) {
        String innerEntity;
        if (tag != null && !tag.m_128456_() && !(innerEntity = tag.m_128461_(NBTKEY_INNER_SPIRIT)).isEmpty()) {
            return (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(innerEntity));
        }
        return null;
    }

    public static EntityVengeanceSpiritData fromNBT(CompoundTag tag) {
        EntityVengeanceSpiritData data = new EntityVengeanceSpiritData();
        data.readNBT(tag);
        return data;
    }

    @Nullable
    public EntityType<?> getInnerEntityType() {
        return this.innerEntityType;
    }

    public int getRemainingLife() {
        return this.remainingLife;
    }

    public int getFrozenDuration() {
        return this.frozenDuration;
    }

    public boolean isSwarm() {
        return this.isSwarm;
    }

    public int getSwarmTier() {
        return this.swarmTier;
    }

    public int getBuildupDuration() {
        return this.buildupDuration;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setInnerEntityType(@Nullable EntityType<?> innerEntityType) {
        this.innerEntityType = innerEntityType;
    }

    public void setRemainingLife(int remainingLife) {
        this.remainingLife = remainingLife;
    }

    public void setFrozenDuration(int frozenDuration) {
        this.frozenDuration = frozenDuration;
    }

    public void setSwarm(boolean isSwarm) {
        this.isSwarm = isSwarm;
    }

    public void setSwarmTier(int swarmTier) {
        this.swarmTier = swarmTier;
    }

    public void setBuildupDuration(int buildupDuration) {
        this.buildupDuration = buildupDuration;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }
}

