/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook.pageelement;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.item.ItemPromise;

public class BloodInfuserRecipeAppendix
extends RecipeAppendix<RecipeBloodInfuser> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButtonEnum INPUT = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum PROMISE = AdvancedButtonEnum.create();

    public BloodInfuserRecipeAppendix(IInfoBook infoBook, RecipeBloodInfuser recipe) {
        super(infoBook, (Object)recipe);
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return 42;
    }

    protected String getUnlocalizedTitle() {
        return "block.evilcraft.blood_infuser";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(PROMISE, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(matrixStack, x + middle - 3, y + 23 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(((RecipeBloodInfuser)this.recipe).getInputIngredient().m_43908_(), tick);
        ItemStack result = this.prepareItemStack(((RecipeBloodInfuser)this.recipe).getOutputItem(), tick);
        ItemStack promise = null;
        if (((RecipeBloodInfuser)this.recipe).getInputTier() > 0) {
            promise = new ItemStack((ItemLike)ItemPromise.getItem(((RecipeBloodInfuser)this.recipe).getInputTier()));
        }
        this.renderItem(gui, matrixStack, x + 16, y + 23, input, mx, my, INPUT);
        this.renderItem(gui, matrixStack, x + 68, y + 23, result, mx, my, RESULT);
        if (promise != null) {
            this.renderItem(gui, matrixStack, x + 16, y + 2, promise, mx, my, PROMISE);
        }
        this.renderItem(gui, matrixStack, x + middle, y + 2, ItemHelpers.getBloodBucket(), mx, my, false, null);
        this.renderItem(gui, matrixStack, x + middle, y + 23, new ItemStack((ItemLike)RegistryEntries.BLOCK_BLOOD_INFUSER), mx, my, false, null);
        Font fontRenderer = gui.getFont();
        FluidStack fluidStack = ((RecipeBloodInfuser)this.recipe).getInputFluid();
        String line = fluidStack.getAmount() + " mB";
        MultiLineLabel.m_94341_((Font)fontRenderer, (FormattedText)new TextComponent(line), (int)200).m_6508_(matrixStack, x + middle + 16 + 1, y + 6, 9, 0);
    }
}

