/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.event.RenderOverlayEventHook;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class ItemBroom
extends ItemBloodContainer
implements IBroom {
    protected static final ResourceLocation OVERLAY = new ResourceLocation("evilcraft", "textures/gui/overlay.png");
    private static final float Y_SPAWN_OFFSET = 1.5f;

    public ItemBroom(Item.Properties properties) {
        super(properties, 10000);
        if (MinecraftHelpers.isClientSide()) {
            MinecraftForge.EVENT_BUS.addListener(this::onFovEvent);
            MinecraftForge.EVENT_BUS.addListener(this::onRenderOverlayEvent);
        }
    }

    @Override
    public boolean isPlaceFluids() {
        return false;
    }

    @Override
    public boolean isPickupFluids() {
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && player.m_20202_() == null && !player.m_6047_()) {
            player.m_6034_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
            EntityBroom entityBroom = new EntityBroom(world, player.m_20185_(), player.m_20186_(), player.m_20189_());
            entityBroom.setBroomStack(stack);
            entityBroom.m_146922_(player.m_146908_());
            world.m_7967_((Entity)entityBroom);
            player.m_20329_((Entity)entityBroom);
            stack.m_41774_(1);
        }
        return MinecraftHelpers.successAction((Object)stack);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!context.m_43725_().m_5776_() && context.m_43723_().m_6047_()) {
            BlockPos blockPos = context.m_8083_();
            if (!BlockEntityHelpers.getCapability((BlockGetter)context.m_43725_(), (BlockPos)blockPos, (Direction)context.m_43719_(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && context.m_43725_().m_46859_(blockPos.m_142022_(0.0, 1.5, 0.0))) {
                EntityBroom entityBroom = new EntityBroom(context.m_43725_(), (double)blockPos.m_123341_() + 0.5, (float)blockPos.m_123342_() + 1.5f, (double)blockPos.m_123343_() + 0.5);
                entityBroom.setBroomStack(stack);
                entityBroom.m_146922_(context.m_43723_().m_146908_());
                context.m_43725_().m_7967_((Entity)entityBroom);
                if (!context.m_43723_().m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Rarity m_41460_(ItemStack itemStack) {
        int maxRarity = 0;
        for (IBroomPart part : this.getBroomParts(itemStack)) {
            maxRarity = Math.max(maxRarity, part.getRarity().ordinal());
        }
        return Rarity.values()[maxRarity];
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack itemStack) {
        return BroomParts.REGISTRY.getBroomParts(itemStack);
    }

    @Override
    public Map<BroomModifier, Float> getBroomModifiers(ItemStack itemStack) {
        return BroomModifiers.REGISTRY.getModifiers(itemStack);
    }

    @Override
    public boolean canConsumeBroomEnergy(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return this.canConsume(amount, itemStack, entityLiving instanceof Player ? (Player)entityLiving : null);
    }

    @Override
    public int consumeBroom(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return FluidHelpers.getAmount((FluidStack)this.consume(amount, itemStack, entityLiving instanceof Player ? (Player)entityLiving : null));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        if (MinecraftHelpers.isShifted()) {
            list.add((Component)new TranslatableComponent("broom.parts.evilcraft.types").m_130940_(ChatFormatting.ITALIC));
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(itemStack);
            Map<BroomModifier, Float> modifiers = this.getBroomModifiers(itemStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(baseModifiers.keySet());
            modifierTypes.addAll(modifiers.keySet());
            for (IBroomPart part : this.getBroomParts(itemStack)) {
                Component line = part.getTooltipLine("  ");
                if (line == null) continue;
                list.add(line);
            }
            Pair<Integer, Integer> modifiersAndMax = this.getModifiersAndMax(modifiers, baseModifiers);
            int modifierCount = (Integer)modifiersAndMax.getLeft();
            int maxModifiers = (Integer)modifiersAndMax.getRight();
            list.add((Component)new TranslatableComponent("broom.modifiers.evilcraft.types.nameparam", new Object[]{modifierCount, maxModifiers}).m_130940_(ChatFormatting.ITALIC));
            for (BroomModifier modifier : modifierTypes) {
                if (!modifier.showTooltip()) continue;
                Float value = modifiers.get(modifier);
                Float baseValue = baseModifiers.get(modifier);
                list.add(modifier.getTooltipLine("  ", value == null ? 0.0f : value.floatValue(), baseValue == null ? 0.0f : baseValue.floatValue()));
            }
        } else {
            list.add((Component)new TranslatableComponent("broom.evilcraft.shiftinfo").m_130940_(ChatFormatting.ITALIC));
        }
    }

    private Pair<Integer, Integer> getModifiersAndMax(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        return Pair.of((Object)modifiers, (Object)maxModifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onFovEvent(FOVModifierEvent event) {
        if (event.getEntity().m_20202_() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)event.getEntity().m_20202_();
            double speed = broom.getLastPlayerSpeed();
            event.setNewfov((float)((double)event.getFov() + speed / 10.0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20202_() instanceof EntityBroom && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            EntityBroom broom = (EntityBroom)player.m_20202_();
            ItemStack broomStack = broom.getBroomStack();
            Window resolution = event.getWindow();
            int height = 21;
            int width = 21;
            RenderOverlayEventHook.OverlayPosition overlayPosition = RenderOverlayEventHook.OverlayPosition.values()[Mth.m_14045_((int)ItemBroomConfig.guiOverlayPosition, (int)0, (int)(RenderOverlayEventHook.OverlayPosition.values().length - 1))];
            int x = overlayPosition.getX(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetX;
            int y = overlayPosition.getY(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetY;
            event.getMatrixStack().m_85836_();
            GlStateManager.m_84525_();
            GlStateManager.m_84328_((int)770, (int)771);
            RenderHelpers.bindTexture((ResourceLocation)OVERLAY);
            Minecraft.m_91087_().f_91065_.m_93228_(event.getMatrixStack(), x, y, 11, 0, 24, 24);
            Lighting.m_84931_();
            Minecraft.m_91087_().m_91291_().m_115203_(broomStack, x + 3, y + 3);
            Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91065_.m_93082_(), broomStack, x + 3, y + 3, "");
            Lighting.m_84930_();
            GlStateManager.m_84519_();
            event.getMatrixStack().m_85849_();
        }
    }
}

