/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;

public class ItemCreativeBloodDrop
extends ItemBloodContainer {
    private static final int MB_FILL_PERTICK = 1000;

    public ItemCreativeBloodDrop(Item.Properties properties) {
        super(properties, 1000);
        this.setPlaceFluids(true);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.m_5524_() + ".info.auto_supply"));
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int par4, boolean par5) {
        ItemCreativeBloodDrop.updateAutoFill(itemStack, world, entity);
        super.m_6883_(itemStack, world, entity, par4, par5);
    }

    public static void updateAutoFill(ItemStack itemStack, Level world, Entity entity) {
        FluidStack tickFluid;
        IFluidHandler source = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (source != null && entity instanceof Player && !world.m_5776_() && ItemHelpers.isActivated(itemStack) && (tickFluid = source.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)) != null && tickFluid.getAmount() > 0) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.m_21120_(hand);
                IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)held).orElse(null);
                if (held.m_41619_() || held == itemStack || fluidHandler == null || player.m_21212_() != 0 || fluidHandler.fill(tickFluid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                int filled = fluidHandler.fill(new FluidStack(tickFluid.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                source.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int m_142158_(ItemStack itemStack) {
        return 13;
    }

    public void m_6787_(CreativeModeTab itemGroup, NonNullList<ItemStack> items) {
        if (ItemStackHelpers.isValidCreativeTab((Item)this, (CreativeModeTab)itemGroup) && this.m_41389_(this.f_41377_)) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43723_().m_6047_()) {
            BlockPos pos = context.m_8083_().m_142082_(0, 1, 0);
            if (RegistryEntries.BLOCK_BLOOD_STAIN.m_7898_(RegistryEntries.BLOCK_BLOOD_STAIN.m_49966_(), (LevelReader)context.m_43725_(), pos)) {
                if (context.m_43725_().m_5776_()) {
                    ParticleBloodSplash.spawnParticles(context.m_43725_(), pos, 5, 1 + context.m_43725_().f_46441_.nextInt(2));
                } else {
                    if (context.m_43725_().m_46859_(pos)) {
                        context.m_43725_().m_46597_(pos, RegistryEntries.BLOCK_BLOOD_STAIN.m_49966_());
                    }
                    if (context.m_43725_().m_8055_(pos).m_60734_() == RegistryEntries.BLOCK_BLOOD_STAIN) {
                        BlockEntityHelpers.get((BlockGetter)context.m_43725_(), (BlockPos)pos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(1000));
                    }
                }
                return InteractionResult.PASS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!player.m_6047_()) {
            return super.m_7203_(world, player, hand);
        }
        BlockHitResult target = ItemCreativeBloodDrop.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!(target != null && target.m_6662_() != HitResult.Type.MISS || world.m_5776_())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FluidHandlerItemCapacity(stack, 1000){

            public FluidStack getFluid() {
                return new FluidStack(ItemCreativeBloodDrop.this.getFluid(), 500);
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return new FluidStack(this.getFluid(), maxDrain);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                return resource.getAmount();
            }
        };
    }
}

