/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.item.ItemMace;

public class ItemMaceOfDistortion
extends ItemMace {
    public static final int AOE_TICK_UPDATE = 20;
    private static final int MAXIMUM_CHARGE = 100;
    private static final float MELEE_DAMAGE = 7.0f;
    private static final float RADIAL_DAMAGE = 3.0f;
    private static final int CONTAINER_SIZE = 4000;
    private static final int HIT_USAGE = 5;
    private static final int POWER_LEVELS = 5;

    public ItemMaceOfDistortion(Item.Properties properties) {
        super(properties, 4000, 5, 100, 5, 7.0f);
    }

    protected void distortEntities(Level world, LivingEntity initiator, int itemUsedCount, int power) {
        double x = initiator.m_20185_();
        double y = initiator.m_20186_();
        double z = initiator.m_20189_();
        double area = this.getArea(itemUsedCount);
        AABB box = new AABB(x, y, z, x, y, z).m_82400_(area);
        List entities = world.m_45933_((Entity)initiator, box);
        boolean onePlayer = false;
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                onePlayer = true;
            }
            this.distortEntity(world, initiator, entity, x, y, z, itemUsedCount, power);
        }
        if (initiator instanceof ServerPlayer) {
            Advancements.DISTORT.test((ServerPlayer)initiator, entities);
        }
    }

    public void distortEntity(Level world, @Nullable LivingEntity initiator, Entity entity, double x, double y, double z, int itemUsedCount, int power) {
        double dz;
        double dy;
        double inverseStrength = initiator != null ? (double)(entity.m_20270_((Entity)initiator) / (float)(itemUsedCount + 1)) : 0.1;
        double knock = (double)(power + itemUsedCount / 200) + 1.0;
        double dx = entity.m_20185_() - x;
        double d = Mth.m_14116_((float)((float)(dx * dx + (dy = entity.m_20186_() + (double)entity.m_20192_() - y) * dy + (dz = entity.m_20189_() - z) * dz)));
        if (d != 0.0) {
            dx /= d;
            dy /= d;
            dz /= d;
            double strength = (1.0 - inverseStrength) * knock;
            if (entity instanceof LivingEntity) {
                ExtendedDamageSource damageSource = initiator == null ? ExtendedDamageSource.distorted : (initiator instanceof Player ? DamageSource.m_19344_((Player)((Player)initiator)) : DamageSource.m_19370_((LivingEntity)initiator));
                entity.m_6469_((DamageSource)damageSource, 3.0f * (float)power);
                if (world.m_5776_()) {
                    ItemMaceOfDistortion.showEntityDistored(world, initiator, entity, power);
                }
            }
            if (entity instanceof EntityVengeanceSpirit) {
                ((EntityVengeanceSpirit)entity).setSwarm(true);
            }
            entity.m_20256_(entity.m_20184_().m_82542_(strength /= 2.0, strength, strength));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showEntityDistored(Level world, LivingEntity initiator, Entity entity, int power) {
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (world.f_46441_.nextFloat() * 0.4f + 0.8f));
        if (initiator != null) {
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (world.f_46441_.nextFloat() * 0.4f + 0.8f));
        }
        world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)world.f_46441_.nextFloat(), entity.m_20189_(), 1.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void animateOutOfEnergy(Level world, Player player) {
        double xCoord = player.m_20185_();
        double yCoord = player.m_20186_();
        double zCoord = player.m_20189_();
        float particleMotionX = world.f_46441_.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.f_46441_.nextFloat() * 0.2f - 0.1f;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.m_6263_(player, xCoord, yCoord, zCoord, SoundEvents.f_12208_, SoundSource.RECORDS, 0.5f, 0.4f / (world.f_46441_.nextFloat() * 0.4f + 0.8f));
    }

    public int getItemEnchantability(ItemStack itemStack) {
        return 15;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 7.0, AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, itemStack);
    }

    @Override
    protected void use(Level world, LivingEntity entity, int itemUsedCount, int power) {
        this.distortEntities(world, entity, itemUsedCount, power);
    }
}

