/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemStack;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.inventory.container.ContainerPrimedPendant;
import org.cyclops.evilcraft.item.ItemPrimedPendantConfig;

public class ItemPrimedPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = 10;

    public ItemPrimedPendant(Item.Properties properties) {
        super(properties, ItemPrimedPendantConfig.capacity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ItemStack potionStack = this.getPotionStack(itemStack);
        if (!potionStack.m_41619_()) {
            List potionEffects = PotionUtils.m_43547_((ItemStack)potionStack);
            for (MobEffectInstance potionEffect : potionEffects) {
                TranslatableComponent textComponent = new TranslatableComponent(super.m_5671_(itemStack) + ".potion", new Object[]{new TranslatableComponent(potionEffect.m_19576_()), new TranslatableComponent("enchantment.level." + (potionEffect.m_19564_() + 1))});
                Double multiplier = ItemPrimedPendantConfig.getMultiplier(potionEffect.m_19544_());
                if (multiplier != null && multiplier < 0.0) {
                    textComponent.m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                list.add((Component)textComponent);
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int par4, boolean par5) {
        if (entity instanceof Player && world.m_46467_() % 10L == 0L) {
            Player player = (Player)entity;
            ItemStack potionStack = this.getPotionStack(itemStack);
            if (!potionStack.m_41619_()) {
                List potionEffects = PotionUtils.m_43547_((ItemStack)potionStack);
                for (MobEffectInstance potionEffect : potionEffects) {
                    int toDrain = ItemPrimedPendantConfig.usage * (potionEffect.m_19564_() + 1);
                    Double multiplier = ItemPrimedPendantConfig.getMultiplier(potionEffect.m_19544_());
                    if (multiplier != null) {
                        toDrain = (int)((double)toDrain * multiplier);
                    }
                    if (multiplier != null && !(multiplier >= 0.0) || !this.canConsume(toDrain, itemStack, player)) continue;
                    player.m_7292_(new MobEffectInstance(potionEffect.m_19544_(), 270, potionEffect.m_19564_(), !potionEffect.getCurativeItems().isEmpty(), true));
                    this.consume(toDrain, itemStack, player);
                }
            }
        }
        super.m_6883_(itemStack, world, entity, par4, par5);
    }

    public boolean hasPotionStack(ItemStack itemStack) {
        return !this.getPotionStack(itemStack).m_41619_();
    }

    public ItemStack getPotionStack(ItemStack itemStack) {
        Container inventory = this.getSupplementaryInventory(itemStack);
        return inventory.m_8020_(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack itemStack) {
        return this.hasPotionStack(itemStack);
    }

    public Container getSupplementaryInventory(Player player, ItemStack itemStack, int itemIndex, InteractionHand hand) {
        return new NBTSimpleInventoryItemHeld(player, itemIndex, hand, 1, 64, "inventoryItem");
    }

    public Container getSupplementaryInventory(ItemStack itemStack) {
        return new NBTSimpleInventoryItemStack(itemStack, 1, 64, "inventoryItem");
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, int itemIndex, InteractionHand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, itemStack.m_41786_(), ContainerPrimedPendant::new);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerPrimedPendant.class;
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player player) {
        if (!itemstack.m_41619_() && player instanceof ServerPlayer && player.f_36096_ != null && player.f_36096_.getClass() == this.getContainerClass(player.f_19853_, player, itemstack)) {
            player.m_6915_();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, int itemIndex, InteractionHand hand) {
        MenuProvider containerProvider;
        if (!world.m_5776_() && (containerProvider = this.getContainer(world, (Player)player, itemIndex, hand, player.m_21120_(hand))) != null) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> this.writeExtraGuiData((FriendlyByteBuf)packetBuffer, world, player, itemIndex, hand));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.m_36246_(openStat);
            }
        }
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, int itemIndex, InteractionHand hand) {
        packetBuffer.writeInt(itemIndex);
        packetBuffer.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player instanceof FakePlayer) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            this.openGuiForItemIndex(world, (ServerPlayer)player, player.m_150109_().f_35977_, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }
}

