/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.world.gen.structure.WorldStructureDarkTempleConfig;
import org.cyclops.evilcraft.world.gen.structure.WorldStructurePieceQuarterSymmetrical;

public class WorldStructureDarkTemple
extends StructureFeature<NoneFeatureConfiguration> {
    public WorldStructureDarkTemple(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn, PieceGeneratorSupplier.m_197349_(WorldStructureDarkTemple::checkLocation, WorldStructureDarkTemple::generatePieces));
    }

    private static <C extends FeatureConfiguration> boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        if (!context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return false;
        }
        return context.m_197372_(21, 21) >= context.f_197352_().m_6337_();
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        int y = 9 + Mth.m_14045_((int)context.f_192703_().m_156174_(context.f_192705_().m_151390_(), context.f_192705_().m_151393_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_192707_()), (int)WorldStructureDarkTempleConfig.darkTempleMinHeight, (int)WorldStructureDarkTempleConfig.darkTempleMaxHeight);
        builder.m_142679_((StructurePiece)new Piece((Random)context.f_192708_(), context.f_192705_().m_45604_(), y, context.f_192705_().m_45605_()));
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends WorldStructurePieceQuarterSymmetrical {
        public Piece(Random random, int x, int y, int z) {
            super(WorldStructureDarkTempleConfig.PIECE_TYPE, x, y, z, 9, 9, 9, Piece.m_163580_((Random)random));
        }

        public Piece(CompoundTag tag) {
            super(WorldStructureDarkTempleConfig.PIECE_TYPE, tag);
        }

        @Override
        protected int getQuarterWidth() {
            return 6;
        }

        @Override
        protected int getQuarterHeight() {
            return 6;
        }

        @Override
        protected void generateLayers() {
            WorldStructurePieceQuarterSymmetrical.BlockWrapper us = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper((BlockState)Blocks.f_50404_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper rs = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper((BlockState)Blocks.f_50404_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper ds = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper((BlockState)Blocks.f_50404_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cb = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50225_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper sb = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50222_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cs = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50409_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper co = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50652_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper wa = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_49990_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper fe = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50483_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper to = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50081_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cw = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50274_);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper lc = new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50087_.m_49966_(), (float)GeneralConfig.darkTempleChestChance);
            lc.action = (world, pos) -> {
                Random rand = new Random();
                RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)rand, (BlockPos)pos, (ResourceLocation)BuiltInLootTables.f_78686_);
            };
            WorldStructurePieceQuarterSymmetrical.BlockWrapper vi = new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.f_50191_.m_49966_(), 0.3f);
            vi.action = (world, pos) -> {
                boolean atLeastOne = false;
                for (Direction side : Direction.Plane.HORIZONTAL) {
                    if (!world.m_8055_(pos.m_142300_(side)).m_60783_((BlockGetter)world, pos.m_142300_(side), side.m_122424_())) continue;
                    world.m_7731_(pos, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57838_.get(side), (Comparable)Boolean.valueOf(true)), 2);
                    atLeastOne = true;
                }
                if (!atLeastOne) {
                    world.m_7471_(pos, true);
                }
            };
            WorldStructurePieceQuarterSymmetrical.BlockWrapper ea = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR);
            Object o = null;
            this.addLayer(1, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, us, ds, vi, us, us, us, us, us, o, us, us, us, us, o, o, us, us, us, us, o, o, us, us, us, us, o, o});
            this.addLayer(2, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, vi, vi, o, o, o, o, cb, cb, vi, sb, sb, sb, sb, cb, vi, ds, co, wa, sb, o, o, co, co, co, sb, o, o, co, co, ds, sb, o, o});
            this.addLayer(3, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, lc, sb, vi, o, o, o, fe, lc, o, rs, o, o, o, o, o, cs, rs, o, o, o, o, ea, cs, rs, o, o, o});
            this.addLayer(4, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, vi, cb, vi, o, o, o, to, vi, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o});
            this.addLayer(5, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{us, o, o, o, cw, o, o, o, o, o, sb, cw, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, us});
            this.addLayer(6, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{cb, ds, rs, rs, rs, o, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, ds, o, co, co, co, co, cb});
            this.addLayer(7, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{rs, o, o, o, o, o, cw, o, o, o, o, o, cs, cs, cs, o, o, o, co, co, cs, cs, o, o, co, co, co, cs, o, o, o, co, co, cs, cw, rs});
            this.addLayer(8, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, cs, cw, o, o, o, o, o, cs, o, o, o, o});
            this.addLayer(9, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o});
        }

        @Override
        protected void postBuildCorner(LevelAccessor world, BlockPos blockPos, int incX, int incZ) {
            world.m_7731_(blockPos.m_142082_(3 * incX, 5, 4 * incZ), (BlockState)((BlockState)((BlockState)Blocks.f_50635_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)DirectionHelpers.getEnumFacingFromXSign((int)incX))).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT), 2);
            world.m_7731_(blockPos.m_142082_(4 * incX, 5, 3 * incZ), (BlockState)((BlockState)((BlockState)Blocks.f_50635_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)DirectionHelpers.getEnumFacingFromZSing((int)incZ))).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT), 2);
            int xx = 4 * incX;
            int zz = 4 * incZ;
            int pillarHeight = this.getPillarHeightForCornerAt(world, blockPos, incX, incZ);
            for (int yOffset = 0; yOffset < pillarHeight; ++yOffset) {
                world.m_7731_(blockPos.m_142082_(xx, -yOffset, zz), Blocks.f_50652_.m_49966_(), 2);
            }
        }

        private int getPillarHeightForCornerAt(LevelAccessor world, BlockPos blockPos, int incX, int incZ) {
            BlockPos loopPos = blockPos.m_142082_(4 * incX, 0, 4 * incZ);
            int res = 0;
            while (!this.isSolidBlock(world, loopPos)) {
                loopPos = loopPos.m_142082_(0, -1, 0);
                ++res;
            }
            return res;
        }

        private boolean isSolidBlock(LevelAccessor world, BlockPos blockPos) {
            return this.isSolidBlock(world.m_8055_(blockPos));
        }

        private boolean isSolidBlock(BlockState blockState) {
            Material material = blockState.m_60767_();
            return material.m_76333_() && material.m_76337_();
        }
    }
}

