/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.WorldStructureConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.world.gen.structure.WorldStructureDarkTemple;

public class WorldStructureDarkTempleConfig
extends WorldStructureConfig {
    @ConfigurableProperty(category="worldgeneration", comment="If dark temple should be added to all dimensions (except for the end and nether).", configLocation=ModConfig.Type.SERVER)
    public static boolean enabled = true;
    @ConfigurableProperty(category="worldgeneration", comment="Minimum block height at which a dark temple can spawn.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleMinHeight = 64;
    @ConfigurableProperty(category="worldgeneration", comment="Maximum blockState height at which a dark temple can spawn.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleMaxHeight = 90;
    @ConfigurableProperty(category="worldgeneration", comment="Average distance between dark temples in chunks.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleSpacing = 40;
    @ConfigurableProperty(category="worldgeneration", comment="Minimum distance between dark temples in chunks, must be smaller than spacing.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleSeparation = 16;
    public static final StructurePieceType PIECE_TYPE = (StructurePieceType)Registry.m_122961_((Registry)Registry.f_122843_, (String)"evilcraft:dark_temple_piece", WorldStructureDarkTemple.Piece::new);
    public static ConfiguredStructureFeature<?, ?> CONFIGURED_FEATURE;

    public WorldStructureDarkTempleConfig() {
        super((ModBase)EvilCraft._instance, "dark_temple", eConfig -> new WorldStructureDarkTemple((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        MinecraftForge.EVENT_BUS.addListener(this::addDimensionalSpacing);
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        CONFIGURED_FEATURE = (ConfiguredStructureFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), this.getNamedId() + "_default"), (Object)((WorldStructureDarkTemple)((Object)this.getInstance())).m_67065_((FeatureConfiguration)FeatureConfiguration.f_67737_));
        StructureFeature.f_67012_.put((Object)this.getResourceKey().m_135782_().toString().toLowerCase(Locale.ROOT), (Object)((StructureFeature)this.getInstance()));
        StructureFeatureConfiguration settings = new StructureFeatureConfiguration(darkTempleSpacing, darkTempleSeparation, 370458167){

            public int m_68171_() {
                return darkTempleSpacing;
            }

            public int m_68176_() {
                return darkTempleSeparation;
            }
        };
        ImmutableSet.of((Object)NoiseGeneratorSettings.f_64432_, (Object)NoiseGeneratorSettings.f_64433_, (Object)NoiseGeneratorSettings.f_64434_, (Object)NoiseGeneratorSettings.f_64435_, (Object)NoiseGeneratorSettings.f_64436_, (Object)NoiseGeneratorSettings.f_64437_, (Object[])new ResourceKey[0]).stream().map(arg_0 -> ((Registry)BuiltinRegistries.f_123866_).m_6246_(arg_0)).map(NoiseGeneratorSettings::m_64457_).map(StructureSettings::m_64590_).forEach(m -> m.put((StructureFeature)this.getInstance(), settings));
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor;
        if (enabled && (levelAccessor = event.getWorld()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap STStructureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                if (((Biome)biomeEntry.getValue()).m_47567_() == Biome.BiomeCategory.THEEND || ((Biome)biomeEntry.getValue()).m_47567_() == Biome.BiomeCategory.NETHER) continue;
                WorldStructureDarkTempleConfig.associateBiomeToConfiguredStructure(STStructureToMultiMap, CONFIGURED_FEATURE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !STStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            STStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)this.getInstance(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get(this.getInstance()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            EvilCraft.clog(String.format("Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\nThis issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\nThe two conflicting ConfiguredStructures are: %s, %s\nThe biome that is attempting to be shared: %s\n", BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey), org.apache.logging.log4j.Level.ERROR);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }
}

