/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeJEI;

public abstract class CommonEnvironmentalAccumulatorRecipeCategory<T extends CommonEnvironmentalAccumulatorRecipeJEI<T>>
implements IRecipeCategory<T> {
    private final Map<WeatherType, IDrawableStatic> weatherIcons;
    private final Pair<Integer, Integer> weatherInPos;
    private final Pair<Integer, Integer> weatherOutPos;
    private T lastRecipe = null;

    public CommonEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper, Pair<Integer, Integer> weatherInPos, Pair<Integer, Integer> weatherOutPos) {
        this.weatherInPos = weatherInPos;
        this.weatherOutPos = weatherOutPos;
        this.weatherIcons = Maps.newHashMap();
        ResourceLocation weatherResourceLocation = new ResourceLocation("evilcraft:textures/gui/weathers.png");
        this.weatherIcons.put(WeatherType.CLEAR, guiHelper.createDrawable(weatherResourceLocation, 0, 0, 16, 16));
        this.weatherIcons.put(WeatherType.RAIN, guiHelper.createDrawable(weatherResourceLocation, 16, 0, 16, 16));
        this.weatherIcons.put(WeatherType.LIGHTNING, guiHelper.createDrawable(weatherResourceLocation, 32, 0, 16, 16));
    }

    public void draw(T recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        if (this.lastRecipe != null) {
            if (((CommonEnvironmentalAccumulatorRecipeJEI)((Object)this.lastRecipe)).getInputWeather() != WeatherType.ANY) {
                this.weatherIcons.get(((CommonEnvironmentalAccumulatorRecipeJEI)((Object)this.lastRecipe)).getInputWeather()).draw(matrixStack, ((Integer)this.weatherInPos.getLeft()).intValue(), ((Integer)this.weatherInPos.getRight()).intValue());
            }
            if (((CommonEnvironmentalAccumulatorRecipeJEI)((Object)this.lastRecipe)).getOutputWeather() != WeatherType.ANY) {
                this.weatherIcons.get(((CommonEnvironmentalAccumulatorRecipeJEI)((Object)this.lastRecipe)).getOutputWeather()).draw(matrixStack, ((Integer)this.weatherOutPos.getLeft()).intValue(), ((Integer)this.weatherOutPos.getRight()).intValue());
            }
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, T recipe, IIngredients ingredients) {
        this.lastRecipe = recipe;
    }
}

