/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEI;

public class EnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory<EnvironmentalAccumulatorRecipeJEI> {
    public static final ResourceLocation NAME = new ResourceLocation("evilcraftcompat", "environmental_accumulator");
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public EnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)2, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)76, (Object)8));
        ResourceLocation resourceLocation = new ResourceLocation("evilcraftcompat", "textures/gui/environmental_accumulator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 94, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 94, 0, 5, 34);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends EnvironmentalAccumulatorRecipeJEI> getRecipeClass() {
        return EnvironmentalAccumulatorRecipeJEI.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent(RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(EnvironmentalAccumulatorRecipeJEI recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItems());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutputItem());
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, EnvironmentalAccumulatorRecipeJEI recipe, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipe, ingredients);
        recipeLayout.getItemStacks().init(0, true, 1, 27);
        recipeLayout.getItemStacks().init(1, false, 75, 27);
        recipeLayout.getItemStacks().set(0, recipe.getInputItems());
        recipeLayout.getItemStacks().set(1, recipe.getOutputItem());
    }

    @Override
    public void draw(EnvironmentalAccumulatorRecipeJEI recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, matrixStack, mouseX, mouseY);
        this.arrow.draw(matrixStack, 44, 0);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.m_92889_(matrixStack, (Component)duration, (float)(this.background.getWidth() - fontRenderer.m_92852_((FormattedText)duration)), 48.0f, -8355712);
    }
}

