/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";
    private static final String PRESET_FLAT_WORLD = "minecraft:bedrock,3*minecraft:stone,52*minecraft:sandstone;minecraft:desert;";
    private static final String PRESET_FLAT_WORLD_JSON = "{\"bonus_chest\":false,\"dimensions\":{\"minecraft:overworld\":{\"type\":\"minecraft:overworld\",\"generator\":{\"settings\":{\"lakes\":false,\"features\":false,\"biome\":\"minecraft:desert\",\"structures\":{\"structures\":{}},\"layers\":[{\"height\":1,\"block\":\"minecraft:bedrock\"},{\"height\":3,\"block\":\"minecraft:stone\"},{\"height\":52,\"block\":\"minecraft:sandstone\"}]},\"type\":\"minecraft:flat\"}},\"minecraft:the_nether\":{\"type\":\"minecraft:the_nether\",\"generator\":{\"biome_source\":{\"preset\":\"minecraft:nether\",\"seed\":-7729799262413108572,\"type\":\"minecraft:multi_noise\"},\"seed\":-7729799262413108572,\"settings\":\"minecraft:nether\",\"type\":\"minecraft:noise\"}},\"minecraft:the_end\":{\"type\":\"minecraft:the_end\",\"generator\":{\"biome_source\":{\"seed\":-7729799262413108572,\"type\":\"minecraft:the_end\"},\"seed\":-7729799262413108572,\"settings\":\"minecraft:end\",\"type\":\"minecraft:noise\"}}},\"seed\":-7729799262413108572,\"generate_features\":false}";

    @SubscribeEvent
    public static void onMainMenuInit(ScreenEvent.InitScreenEvent event) {
        if (GeneralConfig.devWorldButton && event.getScreen() instanceof TitleScreen) {
            event.addListener((GuiEventListener)new Button(event.getScreen().f_96543_ / 2 + 102, event.getScreen().f_96544_ / 4 + 48, 58, 20, (Component)new TranslatableComponent("general.cyclopscore.dev_world"), button -> {
                String saveName;
                Minecraft mc = Minecraft.m_91087_();
                if (!MinecraftHelpers.isShifted()) {
                    LevelSummary devWorldSummary = null;
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    try {
                        for (LevelSummary worldSummary : mc.m_91392_().m_78244_()) {
                            if (!worldSummary.m_78361_().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.m_78366_() >= worldSummary.m_78366_()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (LevelStorageException e) {
                        CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.m_91152_((Screen)new ErrorScreen((Component)new TranslatableComponent("selectWorld.unable_to_load"), (Component)new TextComponent(e.getMessage())));
                    }
                    if (devWorldSummary != null && mc.m_91392_().m_78255_(devWorldSummary.m_78358_())) {
                        mc.m_91200_(devWorldSummary.m_78358_());
                        return;
                    }
                }
                GameRules gameRules = new GameRules();
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46140_)).m_46246_(false, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46156_)).m_46246_(true, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46124_)).m_46246_(false, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46125_)).m_46246_(false, null);
                LevelSettings worldsettings = new LevelSettings(WORLD_NAME_PREFIX, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, gameRules, DataPackConfig.f_45842_);
                int seed = new Random().nextInt();
                RegistryAccess.RegistryHolder dynamicRegistries = RegistryAccess.m_123086_();
                Registry registryDimensionType = dynamicRegistries.m_175515_(Registry.f_122818_);
                Registry registryBiome = dynamicRegistries.m_175515_(Registry.f_122885_);
                MappedRegistry simpleregistry = DimensionType.m_188317_((RegistryAccess)dynamicRegistries, (long)seed);
                FlatLevelGeneratorSettings flatgenerationsettings = PresetFlatWorldScreen.m_96406_((Registry)registryBiome, (String)PRESET_FLAT_WORLD, (FlatLevelGeneratorSettings)FlatLevelGeneratorSettings.m_70376_((Registry)registryBiome));
                WorldGenSettings generatorSettings = new WorldGenSettings((long)seed, false, false, WorldGenSettings.m_64633_((Registry)registryDimensionType, (MappedRegistry)simpleregistry, (ChunkGenerator)new FlatLevelSource(flatgenerationsettings)));
                try {
                    saveName = FileUtil.m_133730_((Path)mc.m_91392_().m_78257_(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.m_91202_(saveName, worldsettings, dynamicRegistries, generatorSettings);
            }));
        }
    }
}

