/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;

public class WidgetArrowedListField<E>
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowLeft;
    private ButtonArrow arrowRight;
    private List<E> elements;
    private int activeElement;
    private IInputListener listener;

    public WidgetArrowedListField(Font fontrenderer, int x, int y, int width, int height, boolean arrows, Component narrationMessage, boolean background, List<E> elements) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowLeft = new ButtonArrow(x, y - 1, (Component)new TranslatableComponent("gui.cyclopscore.left"), button -> this.decrease(), ButtonArrow.Direction.WEST);
            this.arrowRight = new ButtonArrow(x + width, y - 1, (Component)new TranslatableComponent("gui.cyclopscore.right"), button -> this.increase(), ButtonArrow.Direction.EAST);
            this.arrowRight.f_93620_ -= this.arrowRight.m_5711_();
        }
        this.m_94182_(true);
        this.elements = elements;
        this.setActiveElement(0);
    }

    @Override
    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public boolean m_94219_() {
        return false;
    }

    public void setActiveElement(int index) {
        if (index >= this.elements.size()) {
            this.activeElement = -1;
            this.m_94144_("");
        } else {
            this.activeElement = index;
            this.m_94144_(this.activeElementToString(this.getActiveElement()));
        }
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public boolean setActiveElement(E element) {
        int index = this.elements.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.setActiveElement(index);
        return true;
    }

    protected String activeElementToString(E element) {
        return element.toString();
    }

    public E getActiveElement() throws NumberFormatException {
        if (this.activeElement < 0 || this.activeElement >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.activeElement);
    }

    @Override
    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowLeft.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
            this.arrowRight.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
            offsetX = this.arrowLeft.m_5711_();
            this.f_93620_ += offsetX + 1;
            this.f_93618_ -= offsetX * 2;
        }
        super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.f_93620_ -= offsetX + 1;
            this.f_93618_ += offsetX * 2;
        }
    }

    protected void increase() {
        this.setActiveElement((this.activeElement + 1) % this.elements.size());
    }

    protected void decrease() {
        this.setActiveElement((this.activeElement - 1 + this.elements.size()) % this.elements.size());
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return this.arrowLeft.m_6375_(mouseX, mouseY, mouseButton) || this.arrowRight.m_6375_(mouseX, mouseY, mouseButton) || super.m_6375_(mouseX, mouseY, mouseButton);
    }
}

