/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class NBTSimpleInventoryItemHeld
extends SimpleInventory {
    protected final Player player;
    protected final int itemIndex;
    protected final InteractionHand hand;
    protected final String tagName;

    public NBTSimpleInventoryItemHeld(Player player, int itemIndex, int size, int stackLimit, String tagName) {
        this(player, itemIndex, InteractionHand.MAIN_HAND, size, stackLimit, tagName);
    }

    public NBTSimpleInventoryItemHeld(Player player, int itemIndex, InteractionHand hand, int size, int stackLimit, String tagName) {
        super(size, stackLimit);
        this.player = player;
        this.itemIndex = itemIndex;
        this.hand = hand;
        this.tagName = tagName;
        InventoryHelpers.validateNBTStorage(this, InventoryHelpers.getItemFromIndex(player, itemIndex, hand), this.tagName);
    }

    @Override
    public void m_6596_() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex(this.player, this.itemIndex, this.hand);
        CompoundTag tag = itemStack.m_41784_();
        this.writeToNBT(tag, this.tagName);
        InventoryHelpers.getItemFromIndex(this.player, this.itemIndex, this.hand).m_41751_(tag);
    }

    @Override
    public void readFromNBT(CompoundTag data, String tagName) {
        InventoryHelpers.readFromNBT(this, data, tagName);
    }

    @Override
    public void writeToNBT(CompoundTag data, String tagName) {
        InventoryHelpers.writeToNBT(this, data, tagName);
    }
}

