/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;

public abstract class ItemGui
extends Item {
    protected ItemGui(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public abstract MenuProvider getContainer(Level var1, Player var2, int var3, InteractionHand var4, ItemStack var5);

    public abstract Class<? extends AbstractContainerMenu> getContainerClass(Level var1, Player var2, ItemStack var3);

    public boolean onDroppedByPlayer(ItemStack itemstack, Player player) {
        if (!itemstack.m_41619_() && player instanceof ServerPlayer && player.f_36096_ != null && player.f_36096_.getClass() == this.getContainerClass(player.f_19853_, player, itemstack)) {
            player.m_6915_();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, int itemIndex, InteractionHand hand) {
        MenuProvider containerProvider;
        if (!world.m_5776_() && (containerProvider = this.getContainer(world, (Player)player, itemIndex, hand, player.m_21120_(hand))) != null) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> this.writeExtraGuiData((FriendlyByteBuf)packetBuffer, world, player, itemIndex, hand));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.m_36246_(openStat);
            }
        }
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, int itemIndex, InteractionHand hand) {
        packetBuffer.writeInt(itemIndex);
        packetBuffer.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player instanceof FakePlayer) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            this.openGuiForItemIndex(world, (ServerPlayer)player, player.m_150109_().f_35977_, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }
}

