/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import java.lang.reflect.Field;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.cyclops.cyclopscore.init.ModBase;

public final class ConfigurablePropertyData<T> {
    private final ModBase mod;
    private final String category;
    private final String name;
    private final T defaultValue;
    private final String comment;
    private final boolean isCommandable;
    private final ModConfig.Type configLocation;
    private final Field field;
    private final boolean requiresWorldRestart;
    private final boolean requiresMcRestart;
    private final boolean showInGui;
    private final int minValue;
    private final int maxValue;
    private ForgeConfigSpec.ConfigValue<T> configProperty;

    public ConfigurablePropertyData(ModBase mod, String category, String name, T defaultValue, String comment, boolean isCommandable, ModConfig.Type configLocation, Field field, boolean requiresWorldRestart, boolean requiresMcRestart, boolean showInGui, int minValue, int maxValue) {
        this.mod = mod;
        this.category = category;
        this.name = name;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.isCommandable = isCommandable;
        this.field = field;
        this.configLocation = configLocation;
        this.requiresWorldRestart = requiresWorldRestart;
        this.requiresMcRestart = requiresMcRestart;
        this.showInGui = showInGui;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void onConfigInit(ForgeConfigSpec.Builder configBuilder) {
        configBuilder.push(this.category);
        if (this.requiresWorldRestart) {
            configBuilder.worldRestart();
        }
        ForgeConfigSpec.ConfigValue configProperty = configBuilder.comment(this.comment).translation(this.getLanguageKey()).define(this.name, this.defaultValue);
        this.setConfigProperty(configProperty);
        configBuilder.pop();
    }

    private void setConfigProperty(ForgeConfigSpec.ConfigValue<T> configProperty) {
        this.configProperty = configProperty;
    }

    public ForgeConfigSpec.ConfigValue<T> getConfigProperty() {
        return this.configProperty;
    }

    public boolean isCommandable() {
        return this.isCommandable;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public ModConfig.Type getConfigLocation() {
        return this.configLocation;
    }

    public String getLanguageKey() {
        return "config." + this.mod.getModId() + "." + this.name.replaceAll("\\s", "");
    }

    public void saveToField() {
        try {
            this.field.set(null, this.configProperty.get());
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

