/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.item.ItemEntangledChalice;

public class BlockEntangledChalice
extends BlockWithEntity
implements IInformationProvider,
IBlockTank,
IBlockRarityProvider {
    public static final BooleanProperty DRAINING = BooleanProperty.m_61465_((String)"draining");
    public static final ModelProperty<String> TANK_ID = new ModelProperty();
    public static final ModelProperty<FluidStack> TANK_FLUID = new ModelProperty();
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BlockEntangledChalice(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityEntangledChalice::new);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DRAINING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockEntangledChalice.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_ENTANGLED_CHALICE, (BlockEntityTicker)new BlockEntityEntangledChalice.TickerServer());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DRAINING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DRAINING, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)blockPos, (Direction)Direction.UP)) {
            return InteractionResult.SUCCESS;
        }
        if (world.m_5776_()) {
            String tankId = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityEntangledChalice.class).map(BlockEntityEntangledChalice::getWorldTankId).orElse("null");
            player.m_5661_((Component)Component.m_237115_((String)L10NHelpers.localize((String)"block.evilcraft.entangled_chalice.info.id", (Object[])new Object[]{ItemEntangledChalice.tankIdToNameParts(tankId)})), true);
        }
        return super.m_6227_(state, world, blockPos, player, hand, rayTraceResult);
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        return BlockTankHelpers.getInfoTank(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag iTooltipFlag) {
    }

    @Override
    public int getDefaultCapacity() {
        return 4000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.m_6047_()) {
            if (!world.m_5776_()) {
                ItemStack activated = itemStack.m_41777_();
                if (this.isActivated(itemStack, world)) {
                    activated.m_41784_().m_128473_("enabled");
                    if (activated.m_41783_().m_128456_()) {
                        activated.m_41751_(null);
                    }
                } else {
                    activated.m_41784_().m_128379_("enabled", !this.isActivated(itemStack, world));
                }
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, Level world) {
        return ItemHelpers.isActivated(itemStack);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos blockPos) {
        BlockEntityEntangledChalice tank;
        Fluid fluidType;
        BlockEntity tile = world.m_7702_(blockPos);
        if (tile != null && tile instanceof BlockEntityEntangledChalice && (fluidType = (tank = (BlockEntityEntangledChalice)tile).getTank().getFluidType()) != null) {
            return (int)Math.min(15.0, tank.getFillRatio() * (double)fluidType.getFluidType().getLightLevel());
        }
        return 0;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> list) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            ItemEntangledChalice.FluidHandler fluidHandler = (ItemEntangledChalice.FluidHandler)((Object)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null));
            fluidHandler.setTankID("creative");
            list.add((Object)itemStack);
        }
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return Rarity.RARE;
    }
}

