/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.client.Mappings;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class Controller {
    private final int jid;
    private GLFWGamepadState controller;
    private ButtonStates states;
    private String cachedName;
    private Mappings.Entry mapping;

    public Controller(int jid) {
        this.jid = jid;
        this.controller = GLFWGamepadState.create();
        this.states = new ButtonStates();
        this.getName();
    }

    public int getJid() {
        return this.jid;
    }

    public GLFWGamepadState getGamepadState() {
        return this.controller;
    }

    public boolean updateGamepadState() {
        return GLFW.glfwGetGamepadState((int)this.jid, (GLFWGamepadState)this.controller);
    }

    public ButtonStates getButtonsStates() {
        return this.states;
    }

    public String getName() {
        if (GLFW.glfwJoystickPresent((int)this.jid)) {
            if (this.cachedName == null) {
                this.cachedName = GLFW.glfwGetGamepadName((int)this.jid);
            }
            return this.cachedName;
        }
        return I18n.func_135052_a((String)"controllable.toast.controller", (Object[])new Object[0]);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public float getLTriggerValue() {
        return (this.controller.axes(4) + 1.0f) / 2.0f;
    }

    public float getRTriggerValue() {
        return (this.controller.axes(5) + 1.0f) / 2.0f;
    }

    public float getLThumbStickXValue() {
        int axis = this.isThumbsticksSwitched() ? 2 : 0;
        return this.controller.axes(axis) * (float)(this.isFlipLeftX() ? -1 : 1);
    }

    public float getLThumbStickYValue() {
        int axis = this.isThumbsticksSwitched() ? 3 : 1;
        return this.controller.axes(axis) * (float)(this.isFlipLeftY() ? -1 : 1);
    }

    public float getRThumbStickXValue() {
        int axis = this.isThumbsticksSwitched() ? 0 : 2;
        return this.controller.axes(axis) * (float)(this.isFlipRightX() ? -1 : 1);
    }

    public float getRThumbStickYValue() {
        int axis = this.isThumbsticksSwitched() ? 1 : 3;
        return this.controller.axes(axis) * (float)(this.isFlipRightY() ? -1 : 1);
    }

    public void setMapping(Mappings.Entry mapping) {
        this.mapping = mapping;
    }

    @Nullable
    public Mappings.Entry getMapping() {
        return this.mapping;
    }

    private boolean isThumbsticksSwitched() {
        return this.mapping != null && this.mapping.isThumbsticksSwitched();
    }

    public boolean isFlipLeftX() {
        return this.mapping != null && this.mapping.isFlipLeftX();
    }

    public boolean isFlipLeftY() {
        return this.mapping != null && this.mapping.isFlipLeftY();
    }

    public boolean isFlipRightX() {
        return this.mapping != null && this.mapping.isFlipRightX();
    }

    public boolean isFlipRightY() {
        return this.mapping != null && this.mapping.isFlipRightY();
    }
}

