/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.client.ButtonBinding;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class KeyAdapterBinding
extends ButtonBinding {
    private static Field pressedTimeField;
    private final KeyBinding keyBinding;
    private final String labelKey;

    public KeyAdapterBinding(int button, KeyBinding keyBinding) {
        super(button, keyBinding.func_151464_g() + ".custom", "key.categories.controllable_custom", keyBinding.getKeyConflictContext());
        this.keyBinding = keyBinding;
        this.labelKey = keyBinding.func_151464_g();
    }

    @Override
    public String getLabelKey() {
        return this.labelKey;
    }

    public KeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    @Override
    protected void setPressed(boolean pressed) {
        super.setPressed(pressed);
        this.keyBinding.func_225593_a_(pressed);
        if (pressed) {
            this.updateKeyBindPressTime();
        }
        this.handlePressed(pressed ? 1 : 0, this.keyBinding.getKey().func_197937_c(), 0);
    }

    @Override
    protected void onPressTick() {
    }

    private void updateKeyBindPressTime() {
        if (pressedTimeField == null) {
            pressedTimeField = ObfuscationReflectionHelper.findField(KeyBinding.class, (String)"field_151474_i");
        }
        try {
            pressedTimeField.set(this.keyBinding, 1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void handlePressed(int action, int key, int modifiers) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            boolean[] cancelled = new boolean[]{false};
            Screen.func_231153_a_(() -> {
                if (action == 0) {
                    cancelled[0] = ForgeHooksClient.onGuiKeyReleasedPre((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    if (!cancelled[0]) {
                        cancelled[0] = screen.func_223281_a_(key, -1, modifiers);
                    }
                    if (!cancelled[0]) {
                        cancelled[0] = ForgeHooksClient.onGuiKeyReleasedPost((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    }
                } else if (action == 1) {
                    cancelled[0] = ForgeHooksClient.onGuiKeyPressedPre((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    if (!cancelled[0]) {
                        cancelled[0] = screen.func_231046_a_(key, -1, modifiers);
                    }
                    if (!cancelled[0]) {
                        cancelled[0] = ForgeHooksClient.onGuiKeyPressedPost((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    }
                }
            }, (String)"keyPressed event handler", (String)screen.getClass().getCanonicalName());
            if (cancelled[0]) {
                return;
            }
        }
        ForgeHooksClient.fireKeyInput((int)this.keyBinding.getKey().func_197937_c(), (int)0, (int)action, (int)0);
    }
}

