/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.settings;

import com.mrcrayfish.controllable.client.IToolTip;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class ControllableEnumOption<T extends Enum<T>>
extends AbstractOption
implements IToolTip {
    private Class<T> enumClass;
    private int ordinal = 0;
    private Function<GameSettings, T> getter;
    private BiConsumer<GameSettings, T> setter;
    private BiFunction<GameSettings, ControllableEnumOption<T>, ITextComponent> displayNameGetter;
    private TranslationTextComponent toolTip;

    public ControllableEnumOption(String title, Class<T> enumClass, Function<GameSettings, T> getter, BiConsumer<GameSettings, T> setter, BiFunction<GameSettings, ControllableEnumOption<T>, ITextComponent> displayNameGetter) {
        super(title);
        this.enumClass = enumClass;
        this.getter = getter;
        this.setter = setter;
        this.displayNameGetter = displayNameGetter;
        this.toolTip = new TranslationTextComponent(title + ".desc");
    }

    private void nextEnum(GameSettings options) {
        this.set(options, this.getEnum(++this.ordinal));
    }

    public void set(GameSettings options, T t) {
        this.setter.accept(options, (GameSettings)t);
        this.ordinal = ((Enum)t).ordinal();
    }

    public T get(GameSettings options) {
        Enum t = (Enum)this.getter.apply(options);
        this.ordinal = t.ordinal();
        return (T)t;
    }

    public Widget func_216586_a(GameSettings options, int x, int y, int width) {
        return new OptionButton(x, y, width, 20, (AbstractOption)this, this.getTitle(options), button -> {
            this.nextEnum(options);
            button.func_238482_a_(this.getTitle(options));
        });
    }

    public ITextComponent getTitle(GameSettings options) {
        return this.displayNameGetter.apply(options, this);
    }

    private T getEnum(int ordinal) {
        Enum[] e = (Enum[])this.enumClass.getEnumConstants();
        if (ordinal >= e.length) {
            ordinal = 0;
        }
        return (T)e[ordinal];
    }

    @Override
    public List<IReorderingProcessor> getToolTip() {
        return Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)this.toolTip, 200);
    }
}

