/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Buttons;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BindingRegistry {
    private static BindingRegistry instance;
    private List<ButtonBinding> bindings = new ArrayList<ButtonBinding>();
    private Map<String, ButtonBinding> registeredBindings = new HashMap<String, ButtonBinding>();
    private Map<Integer, List<ButtonBinding>> idToButtonList = new HashMap<Integer, List<ButtonBinding>>();

    public static BindingRegistry getInstance() {
        if (instance == null) {
            instance = new BindingRegistry();
        }
        return instance;
    }

    private BindingRegistry() {
    }

    List<ButtonBinding> getRegisteredBindings() {
        return this.bindings;
    }

    List<ButtonBinding> getBindingListForButton(int button) {
        List<ButtonBinding> list = this.idToButtonList.get(button);
        return list != null ? ImmutableList.copyOf(list) : ImmutableList.of();
    }

    public List<ButtonBinding> getBindings() {
        return ImmutableList.copyOf(this.bindings);
    }

    public void register(ButtonBinding binding) {
        if (this.registeredBindings.putIfAbsent(binding.getDescription(), binding) == null) {
            this.bindings.add(binding);
            this.idToButtonList.computeIfAbsent(binding.getButton(), i -> new ArrayList()).add(binding);
        }
    }

    public void resetBindingHash() {
        this.idToButtonList.clear();
        this.bindings.stream().filter(binding -> binding.getButton() != -1).forEach(binding -> this.idToButtonList.computeIfAbsent(binding.getButton(), i -> new ArrayList()).add(binding));
    }

    public void load() {
        File file = new File(Controllable.getConfigFolder(), "controllable/bindings.properties");
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            this.bindings.stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
                String name = properties.getProperty(binding.getDescription(), Buttons.getNameForButton(binding.getButton()));
                if (name != null) {
                    binding.setButton(Buttons.getButtonFromName(name));
                }
            });
            this.resetBindingHash();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        Properties properties = new Properties();
        this.bindings.stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            String name = Buttons.getNameForButton(binding.getButton());
            if (name != null) {
                properties.put(binding.getDescription(), name);
            }
        });
        try {
            File file = new File(Controllable.getConfigFolder(), "controllable/bindings.properties");
            properties.store(new FileOutputStream(file), "Button Bindings");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        BindingRegistry.getInstance().register(ButtonBindings.JUMP);
        BindingRegistry.getInstance().register(ButtonBindings.SNEAK);
        BindingRegistry.getInstance().register(ButtonBindings.SPRINT);
        BindingRegistry.getInstance().register(ButtonBindings.INVENTORY);
        BindingRegistry.getInstance().register(ButtonBindings.SWAP_HANDS);
        BindingRegistry.getInstance().register(ButtonBindings.DROP_ITEM);
        BindingRegistry.getInstance().register(ButtonBindings.USE_ITEM);
        BindingRegistry.getInstance().register(ButtonBindings.ATTACK);
        BindingRegistry.getInstance().register(ButtonBindings.PICK_BLOCK);
        BindingRegistry.getInstance().register(ButtonBindings.PLAYER_LIST);
        BindingRegistry.getInstance().register(ButtonBindings.TOGGLE_PERSPECTIVE);
        BindingRegistry.getInstance().register(ButtonBindings.SCREENSHOT);
        BindingRegistry.getInstance().register(ButtonBindings.SCROLL_LEFT);
        BindingRegistry.getInstance().register(ButtonBindings.SCROLL_RIGHT);
        BindingRegistry.getInstance().register(ButtonBindings.PAUSE_GAME);
        BindingRegistry.getInstance().register(ButtonBindings.NEXT_CREATIVE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.PREVIOUS_CREATIVE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.NEXT_RECIPE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.PREVIOUS_RECIPE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_UP);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_DOWN);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_LEFT);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_RIGHT);
        BindingRegistry.getInstance().register(ButtonBindings.PICKUP_ITEM);
        BindingRegistry.getInstance().register(ButtonBindings.QUICK_MOVE);
        BindingRegistry.getInstance().register(ButtonBindings.SPLIT_STACK);
        BindingRegistry.getInstance().register(ButtonBindings.ADVANCEMENTS);
        BindingRegistry.getInstance().register(ButtonBindings.HIGHLIGHT_PLAYERS);
        BindingRegistry.getInstance().register(ButtonBindings.CINEMATIC_CAMERA);
        BindingRegistry.getInstance().register(ButtonBindings.FULLSCREEN);
        BindingRegistry.getInstance().register(ButtonBindings.DEBUG_INFO);
    }
}

