/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SlotNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.GatherNavigationPointsEvent;
import com.mrcrayfish.controllable.integration.JustEnoughItems;
import com.mrcrayfish.controllable.mixin.client.CreativeScreenMixin;
import com.mrcrayfish.controllable.mixin.client.RecipeBookGuiMixin;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.advancements.AdvancementsScreen;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.recipebook.RecipeBookPage;
import net.minecraft.client.gui.recipebook.RecipeTabToggleWidget;
import net.minecraft.client.gui.recipebook.RecipeWidget;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemGroup;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ControllerInput {
    private static final ResourceLocation CURSOR_TEXTURE = new ResourceLocation("controllable", "textures/gui/cursor.png");
    private int lastUse = 0;
    private boolean keyboardSneaking = false;
    private boolean sneaking = false;
    private boolean isFlying = false;
    private boolean nearSlot = false;
    private boolean moving = false;
    private boolean preventReset;
    private double virtualMouseX;
    private double virtualMouseY;
    private int prevTargetMouseX;
    private int prevTargetMouseY;
    private int targetMouseX;
    private int targetMouseY;
    private double mouseSpeedX;
    private double mouseSpeedY;
    private boolean moved;
    private float targetPitch;
    private float targetYaw;
    private int dropCounter = -1;

    public double getVirtualMouseX() {
        return this.virtualMouseX;
    }

    public double getVirtualMouseY() {
        return this.virtualMouseY;
    }

    private void setControllerInUse() {
        this.lastUse = 100;
    }

    public boolean isControllerInUse() {
        return this.lastUse > 0;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    public void resetLastUse() {
        if (!this.preventReset) {
            this.lastUse = 0;
        }
        this.preventReset = false;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Controller controller;
            this.prevTargetMouseX = this.targetMouseX;
            this.prevTargetMouseY = this.targetMouseY;
            if (this.lastUse > 0) {
                --this.lastUse;
            }
            if ((controller = Controllable.getController()) == null) {
                return;
            }
            if ((Math.abs(controller.getLTriggerValue()) >= 0.2f || Math.abs(controller.getRTriggerValue()) >= 0.2f) && !(Minecraft.func_71410_x().field_71462_r instanceof ControllerLayoutScreen)) {
                this.setControllerInUse();
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71417_B.func_198035_h()) {
                return;
            }
            if (mc.field_71462_r == null || mc.field_71462_r instanceof ControllerLayoutScreen) {
                return;
            }
            float deadZone = (float)Math.min(1.0, (Double)Config.CLIENT.options.deadZone.get() + 0.25);
            boolean lastMoving = this.moving;
            boolean bl = this.moving = Math.abs(controller.getLThumbStickXValue()) >= deadZone || Math.abs(controller.getLThumbStickYValue()) >= deadZone;
            if (this.moving) {
                float xAxis;
                if (!lastMoving) {
                    double mouseX = mc.field_71417_B.func_198024_e();
                    double mouseY = mc.field_71417_B.func_198026_f();
                    if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue()) {
                        mouseX = this.virtualMouseX;
                        mouseY = this.virtualMouseY;
                    }
                    this.prevTargetMouseX = this.targetMouseX = (int)mouseX;
                    this.prevTargetMouseY = this.targetMouseY = (int)mouseY;
                }
                this.mouseSpeedX = Math.abs(xAxis = controller.getLThumbStickXValue()) >= deadZone ? (double)(Math.signum(xAxis) * (Math.abs(xAxis) - deadZone) / (1.0f - deadZone)) : 0.0;
                float yAxis = controller.getLThumbStickYValue();
                this.mouseSpeedY = Math.abs(yAxis) >= deadZone ? (double)(Math.signum(yAxis) * (Math.abs(yAxis) - deadZone) / (1.0f - deadZone)) : 0.0;
                this.setControllerInUse();
            }
            if (this.lastUse <= 0) {
                this.mouseSpeedX = 0.0;
                this.mouseSpeedY = 0.0;
                return;
            }
            if (Math.abs(this.mouseSpeedX) > 0.0 || Math.abs(this.mouseSpeedY) > 0.0) {
                IGuiEventListener hoveredListener;
                RecipeBookGui recipeBook;
                ContainerScreen screen;
                double mouseSpeed = (Double)Config.CLIENT.options.mouseSpeed.get() * mc.func_228018_at_().func_198100_s();
                if (mc.field_71462_r instanceof ContainerScreen && (screen = (ContainerScreen)mc.field_71462_r).getSlotUnderMouse() != null) {
                    mouseSpeed *= 0.5;
                }
                double mouseX = this.virtualMouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
                double mouseY = this.virtualMouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
                ArrayList<Object> eventListeners = new ArrayList<Object>(mc.field_71462_r.children());
                if (mc.field_71462_r instanceof IRecipeShownListener && (recipeBook = ((IRecipeShownListener)mc.field_71462_r).func_194310_f()).func_191878_b()) {
                    eventListeners.add(((RecipeBookGuiMixin)recipeBook).getToggleRecipesBtn());
                    eventListeners.addAll(((RecipeBookGuiMixin)recipeBook).getRecipeTabs());
                    RecipeBookPage recipeBookPage = ((RecipeBookGuiMixin)recipeBook).getRecipeBookPage();
                    eventListeners.addAll(((RecipeBookPageAccessor)recipeBookPage).getButtons());
                    eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).getForwardButton());
                    eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).getBackButton());
                }
                if ((hoveredListener = (IGuiEventListener)eventListeners.stream().filter(o -> o != null && o.isMouseOver(mouseX, mouseY)).findFirst().orElse(null)) != null && !(hoveredListener instanceof AbstractList)) {
                    mouseSpeed *= 0.6;
                }
                this.targetMouseX = (int)((double)this.targetMouseX + mouseSpeed * this.mouseSpeedX);
                this.targetMouseX = MathHelper.func_76125_a((int)this.targetMouseX, (int)0, (int)mc.func_228018_at_().func_198105_m());
                this.targetMouseY = (int)((double)this.targetMouseY + mouseSpeed * this.mouseSpeedY);
                this.targetMouseY = MathHelper.func_76125_a((int)this.targetMouseY, (int)0, (int)mc.func_228018_at_().func_198083_n());
                this.setControllerInUse();
                this.moved = true;
            }
            this.moveMouseToClosestSlot(this.moving, mc.field_71462_r);
            if (mc.field_71462_r instanceof CreativeScreen) {
                this.handleCreativeScrolling((CreativeScreen)mc.field_71462_r, controller);
            }
            if (((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && (this.targetMouseX != this.prevTargetMouseX || this.targetMouseY != this.prevTargetMouseY)) {
                this.performMouseDrag(this.virtualMouseX, this.virtualMouseY, this.targetMouseX - this.prevTargetMouseX, this.targetMouseY - this.prevTargetMouseY);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onScreenInit(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            this.nearSlot = false;
            this.moved = false;
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
            this.targetMouseX = this.prevTargetMouseX = (int)((float)mc.func_228018_at_().func_198105_m() / 2.0f);
            this.virtualMouseX = this.prevTargetMouseX;
            this.targetMouseY = this.prevTargetMouseY = (int)((float)mc.func_228018_at_().func_198083_n() / 2.0f);
            this.virtualMouseY = this.prevTargetMouseY;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r == null || this.targetMouseX == this.prevTargetMouseX && this.targetMouseY == this.prevTargetMouseY || mc.field_71462_r instanceof ControllerLayoutScreen)) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            double mouseX = (double)((float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * partialTicks) + 0.5;
            double mouseY = (double)((float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * partialTicks) + 0.5;
            this.setMousePosition(mouseX, mouseY);
        }
    }

    private void performMouseDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (Controllable.getController() != null) {
            Minecraft mc = Minecraft.func_71410_x();
            Screen screen = mc.field_71462_r;
            if (screen != null && mc.field_213279_p == null) {
                double finalMouseX = mouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
                double finalMouseY = mouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
                Screen.wrapScreenError(() -> screen.func_212927_b(finalMouseX, finalMouseY), (String)"mouseMoved event handler", (String)screen.getClass().getCanonicalName());
                if (mc.field_71417_B.field_198042_g != -1 && mc.field_71417_B.field_198045_j > 0.0) {
                    Screen.wrapScreenError(() -> {
                        double finalDragY;
                        double finalDragX = dragX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
                        if (ForgeHooksClient.onGuiMouseDragPre((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)mc.field_71417_B.field_198042_g, (double)finalDragX, (double)(finalDragY = dragY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n()))) {
                            return;
                        }
                        if (screen.mouseDragged(finalMouseX, finalMouseY, mc.field_71417_B.field_198042_g, finalDragX, finalDragY)) {
                            return;
                        }
                        ForgeHooksClient.onGuiMouseDragPost((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)mc.field_71417_B.field_198042_g, (double)finalDragX, (double)finalDragY);
                    }, (String)"mouseDragged event handler", (String)screen.getClass().getCanonicalName());
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && this.lastUse > 0) {
            RenderSystem.pushMatrix();
            CursorType type = (CursorType)((Object)Config.CLIENT.options.cursorType.get());
            Minecraft minecraft = event.getGui().getMinecraft();
            if (minecraft.field_71439_g == null || minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() || type == CursorType.CONSOLE) {
                double mouseX = (float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * Minecraft.func_71410_x().func_184121_ak();
                double mouseY = (float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * Minecraft.func_71410_x().func_184121_ak();
                RenderSystem.translated((double)(mouseX / minecraft.func_228018_at_().func_198100_s()), (double)(mouseY / minecraft.func_228018_at_().func_198100_s()), (double)500.0);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableLighting();
                event.getGui().getMinecraft().func_110434_K().func_110577_a(CURSOR_TEXTURE);
                if (type == CursorType.CONSOLE) {
                    RenderSystem.scaled((double)0.5, (double)0.5, (double)0.5);
                }
                Screen.blit((int)-8, (int)-8, (int)16, (int)16, (float)(this.nearSlot ? 16.0f : 0.0f), (float)(type.ordinal() * 16), (int)16, (int)16, (int)32, (int)(CursorType.values().length * 16));
            }
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player;
        IGuiEventListener hoveredListener;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        double mouseX = this.virtualMouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
        double mouseY = this.virtualMouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
        if (mc.field_71462_r != null && this.lastUse > 0 && (hoveredListener = (IGuiEventListener)mc.field_71462_r.children().stream().filter(o -> o.isMouseOver(mouseX, mouseY)).findFirst().orElse(null)) instanceof AbstractList) {
            this.handleListScrolling((AbstractList)hoveredListener, controller);
        }
        if ((player = mc.field_71439_g) == null) {
            return;
        }
        if (mc.field_71462_r == null && (this.targetYaw != 0.0f || this.targetPitch != 0.0f)) {
            float elapsedTicks = Minecraft.func_71410_x().func_193989_ak();
            player.func_195049_a((double)this.targetYaw / 0.15 * (double)elapsedTicks, (double)this.targetPitch / 0.15 * (double)((Boolean)Config.CLIENT.options.invertLook.get() != false ? -1 : 1) * (double)elapsedTicks);
            if (player.func_184187_bx() != null) {
                player.func_184187_bx().func_184190_l((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (mc.field_71462_r == null) {
            ControllerEvent.Turn turnEvent;
            double rotationSpeed;
            float deadZone = ((Double)Config.CLIENT.options.deadZone.get()).floatValue();
            if (Math.abs(controller.getRThumbStickXValue()) >= deadZone) {
                this.setControllerInUse();
                rotationSpeed = (Double)Config.CLIENT.options.rotationSpeed.get();
                turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed, (float)rotationSpeed * 0.75f);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimX = (float)(controller.getRThumbStickXValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetYaw = turnEvent.getYawSpeed() * (controller.getRThumbStickXValue() - deadZoneTrimX) / (1.0f - deadZone) * 0.33f;
                }
            }
            if (Math.abs(controller.getRThumbStickYValue()) >= deadZone) {
                this.setControllerInUse();
                rotationSpeed = (Double)Config.CLIENT.options.rotationSpeed.get();
                turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed, (float)rotationSpeed * 0.75f);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimY = (float)(controller.getRThumbStickYValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetPitch = turnEvent.getPitchSpeed() * (controller.getRThumbStickYValue() - deadZoneTrimY) / (1.0f - deadZone) * 0.33f;
                }
            }
        }
        if (mc.field_71462_r == null && ButtonBindings.DROP_ITEM.isButtonDown()) {
            this.setControllerInUse();
            ++this.dropCounter;
        }
        if (this.dropCounter > 20) {
            if (!mc.field_71439_g.func_175149_v()) {
                mc.field_71439_g.func_225609_n_(true);
            }
            this.dropCounter = 0;
        } else if (this.dropCounter > 0 && !ButtonBindings.DROP_ITEM.isButtonDown()) {
            if (!mc.field_71439_g.func_175149_v()) {
                mc.field_71439_g.func_225609_n_(false);
            }
            this.dropCounter = 0;
        }
    }

    @SubscribeEvent
    public void onInputUpdate(InputUpdateEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (this.keyboardSneaking && !mc.field_71474_y.field_228046_af_.func_151470_d()) {
            this.sneaking = false;
            this.keyboardSneaking = false;
        }
        if (mc.field_71474_y.field_228046_af_.func_151470_d()) {
            this.sneaking = true;
            this.keyboardSneaking = true;
        }
        if (mc.field_71439_g.field_71075_bZ.field_75100_b || mc.field_71439_g.func_184218_aH()) {
            this.sneaking = mc.field_71474_y.field_228046_af_.func_151470_d();
            this.sneaking |= ButtonBindings.SNEAK.isButtonDown();
            if (ButtonBindings.SNEAK.isButtonDown()) {
                this.setControllerInUse();
            }
            this.isFlying = true;
        } else if (this.isFlying) {
            this.sneaking = false;
            this.isFlying = false;
        }
        event.getMovementInput().field_228350_h_ = this.sneaking;
        if (mc.field_71462_r == null) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new ControllerEvent.Move(controller))) {
                int dir;
                float deadZone = ((Double)Config.CLIENT.options.deadZone.get()).floatValue();
                if (Math.abs(controller.getLThumbStickYValue()) >= deadZone) {
                    this.setControllerInUse();
                    dir = controller.getLThumbStickYValue() > 0.0f ? -1 : 1;
                    event.getMovementInput().field_187255_c = dir > 0;
                    event.getMovementInput().field_187256_d = dir < 0;
                    event.getMovementInput().field_192832_b = (float)dir * MathHelper.func_76131_a((float)((Math.abs(controller.getLThumbStickYValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                    if (event.getMovementInput().field_228350_h_) {
                        event.getMovementInput().field_192832_b = (float)((double)event.getMovementInput().field_192832_b * 0.3);
                    }
                }
                if (player.func_184187_bx() instanceof BoatEntity) {
                    deadZone = 0.5f;
                }
                if (Math.abs(controller.getLThumbStickXValue()) >= deadZone) {
                    this.setControllerInUse();
                    dir = controller.getLThumbStickXValue() > 0.0f ? -1 : 1;
                    event.getMovementInput().field_187258_f = dir < 0;
                    event.getMovementInput().field_187257_e = dir > 0;
                    event.getMovementInput().field_78902_a = (float)dir * MathHelper.func_76131_a((float)((Math.abs(controller.getLThumbStickXValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                    if (event.getMovementInput().field_228350_h_) {
                        event.getMovementInput().field_78902_a = (float)((double)event.getMovementInput().field_78902_a * 0.3);
                    }
                }
            }
            if (ButtonBindings.JUMP.isButtonDown()) {
                event.getMovementInput().field_78901_c = true;
            }
        }
        if (ButtonBindings.USE_ITEM.isButtonDown() && mc.field_71467_ac == 0 && !mc.field_71439_g.func_184587_cr()) {
            mc.func_147121_ag();
        }
    }

    public void handleButtonInput(Controller controller, int button, boolean state) {
        this.setControllerInUse();
        ControllerEvent.ButtonInput eventInput = new ControllerEvent.ButtonInput(controller, button, state);
        if (MinecraftForge.EVENT_BUS.post((Event)eventInput)) {
            return;
        }
        button = eventInput.getModifiedButton();
        ButtonBinding.setButtonState(button, state);
        ControllerEvent.Button event = new ControllerEvent.Button(controller);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (state) {
            if (ButtonBindings.FULLSCREEN.isButtonPressed()) {
                mc.func_228018_at_().func_198077_g();
                mc.field_71474_y.field_74353_u = mc.func_228018_at_().func_198113_j();
                mc.field_71474_y.func_74303_b();
            } else if (ButtonBindings.SCREENSHOT.isButtonPressed()) {
                if (mc.field_71441_e != null) {
                    ScreenShotHelper.func_148260_a((File)mc.field_71412_D, (int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (Framebuffer)mc.func_147110_a(), textComponent -> mc.execute(() -> mc.field_71456_v.func_146158_b().func_146227_a(textComponent)));
                }
            } else if (mc.field_71462_r == null) {
                if (ButtonBindings.INVENTORY.isButtonPressed()) {
                    if (mc.field_71442_b.func_110738_j()) {
                        mc.field_71439_g.func_175163_u();
                    } else {
                        mc.func_193032_ao().func_193296_a();
                        mc.func_147108_a((Screen)new InventoryScreen((PlayerEntity)mc.field_71439_g));
                    }
                } else if (ButtonBindings.SPRINT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.func_70031_b(true);
                    }
                } else if (ButtonBindings.SNEAK.isButtonPressed()) {
                    if (mc.field_71439_g != null && !mc.field_71439_g.field_71075_bZ.field_75100_b && !mc.field_71439_g.func_184218_aH()) {
                        this.sneaking = !this.sneaking;
                    }
                } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.field_71071_by.func_195409_a(-1.0);
                    }
                } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.field_71071_by.func_195409_a(1.0);
                    }
                } else if (ButtonBindings.SWAP_HANDS.isButtonPressed()) {
                    if (mc.field_71439_g != null && !mc.field_71439_g.func_175149_v() && mc.func_147114_u() != null) {
                        mc.func_147114_u().func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.SWAP_HELD_ITEMS, BlockPos.field_177992_a, Direction.DOWN));
                    }
                } else if (ButtonBindings.TOGGLE_PERSPECTIVE.isButtonPressed() && mc.field_71417_B.func_198035_h()) {
                    this.cycleThirdPersonView();
                } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.func_71385_j(false);
                    }
                } else if (ButtonBindings.ADVANCEMENTS.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.func_147108_a((Screen)new AdvancementsScreen(mc.field_71439_g.field_71174_a.func_191982_f()));
                    }
                } else if (ButtonBindings.CINEMATIC_CAMERA.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71474_y.field_74326_T = !mc.field_71474_y.field_74326_T;
                    }
                } else if (ButtonBindings.DEBUG_INFO.isButtonPressed()) {
                    mc.field_71474_y.field_74330_P = !mc.field_71474_y.field_74330_P;
                } else if (mc.field_71439_g != null && !mc.field_71439_g.func_184587_cr()) {
                    if (ButtonBindings.ATTACK.isButtonPressed()) {
                        mc.func_147116_af();
                    } else if (ButtonBindings.USE_ITEM.isButtonPressed()) {
                        mc.func_147121_ag();
                    } else if (ButtonBindings.PICK_BLOCK.isButtonPressed()) {
                        mc.func_147112_ai();
                    }
                }
            } else if (ButtonBindings.INVENTORY.isButtonPressed()) {
                if (mc.field_71439_g != null) {
                    mc.field_71439_g.func_71053_j();
                }
            } else if (ButtonBindings.PREVIOUS_CREATIVE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof CreativeScreen) {
                    this.scrollCreativeTabs((CreativeScreen)mc.field_71462_r, 1);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipePage(recipeShownListener.func_194310_f(), 1);
                }
            } else if (ButtonBindings.NEXT_CREATIVE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof CreativeScreen) {
                    this.scrollCreativeTabs((CreativeScreen)mc.field_71462_r, -1);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipePage(recipeShownListener.func_194310_f(), -1);
                }
            } else if (ButtonBindings.NEXT_RECIPE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipeTab(recipeShownListener.func_194310_f(), -1);
                }
            } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipeTab(recipeShownListener.func_194310_f(), 1);
                }
            } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                if (mc.field_71462_r instanceof IngameMenuScreen) {
                    mc.func_147108_a(null);
                }
            } else if (ButtonBindings.NAVIGATE_UP.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.UP);
            } else if (ButtonBindings.NAVIGATE_DOWN.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.DOWN);
            } else if (ButtonBindings.NAVIGATE_LEFT.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.LEFT);
            } else if (ButtonBindings.NAVIGATE_RIGHT.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.RIGHT);
            } else if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseClick(mc.field_71462_r, 0);
                if (((Boolean)Config.CLIENT.options.quickCraft.get()).booleanValue()) {
                    this.craftRecipeBookItem();
                }
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseClick(mc.field_71462_r, 1);
            } else if (button == ButtonBindings.QUICK_MOVE.getButton() && mc.field_71439_g != null) {
                if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.invokeMouseClick(mc.field_71462_r, 0);
                } else {
                    this.invokeMouseReleased(mc.field_71462_r, 1);
                }
            }
        } else if (mc.field_71462_r != null) {
            if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseReleased(mc.field_71462_r, 0);
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseReleased(mc.field_71462_r, 1);
            }
        }
    }

    private void cycleThirdPersonView() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74320_O = (mc.field_71474_y.field_74320_O + 1) % 3;
        if (mc.field_71474_y.field_74320_O == 0) {
            mc.field_71460_t.func_175066_a(mc.func_175606_aa());
        } else if (mc.field_71474_y.field_74320_O == 1) {
            mc.field_71460_t.func_175066_a(null);
        }
    }

    private void scrollCreativeTabs(CreativeScreen creative, int dir) {
        this.setControllerInUse();
        try {
            Method method = ObfuscationReflectionHelper.findMethod(CreativeScreen.class, (String)"func_147050_b", (Class[])new Class[]{ItemGroup.class});
            method.setAccessible(true);
            if (dir > 0) {
                if (creative.func_147056_g() < ItemGroup.field_78032_a.length - 1) {
                    method.invoke((Object)creative, ItemGroup.field_78032_a[creative.func_147056_g() + 1]);
                }
            } else if (dir < 0 && creative.func_147056_g() > 0) {
                method.invoke((Object)creative, ItemGroup.field_78032_a[creative.func_147056_g() - 1]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void scrollRecipeTab(RecipeBookGui recipeBook, int dir) {
        RecipeBookGuiMixin recipeBookMixin = (RecipeBookGuiMixin)recipeBook;
        RecipeTabToggleWidget currentTab = recipeBookMixin.getCurrentTab();
        List<RecipeTabToggleWidget> tabs = recipeBookMixin.getRecipeTabs();
        int nextTabIndex = tabs.indexOf(currentTab) + dir;
        if (nextTabIndex >= 0 && nextTabIndex < tabs.size()) {
            RecipeTabToggleWidget newTab = tabs.get(nextTabIndex);
            currentTab.func_191753_b(false);
            recipeBookMixin.setCurrentTab(newTab);
            newTab.func_191753_b(true);
            recipeBookMixin.invokeUpdateCollections(true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    private void scrollRecipePage(RecipeBookGui recipeBook, int dir) {
        RecipeBookPageAccessor page = (RecipeBookPageAccessor)((RecipeBookGuiMixin)recipeBook).getRecipeBookPage();
        if (dir > 0 && page.getForwardButton().visible || dir < 0 && page.getBackButton().visible) {
            int currentPage = page.getCurrentPage();
            page.setCurrentPage(currentPage + dir);
            page.invokeUpdateButtonsForPage();
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    private void navigateMouse(Screen screen, Navigate navigate) {
        Minecraft mc = Minecraft.func_71410_x();
        int mouseX = (int)((double)this.targetMouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
        int mouseY = (int)((double)this.targetMouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
        List<NavigationPoint> points = this.gatherNavigationPoints(screen);
        GatherNavigationPointsEvent event = new GatherNavigationPointsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        points.addAll(event.getPoints());
        List targetPoints = points.stream().filter(point -> navigate.getPredicate().test((NavigationPoint)point, mouseX, mouseY)).collect(Collectors.toList());
        if (targetPoints.isEmpty()) {
            return;
        }
        Vec3d mousePos = new Vec3d((double)mouseX, (double)mouseY, 0.0);
        Optional<NavigationPoint> minimumPointOptional = targetPoints.stream().min(navigate.getMinComparator(mouseX, mouseY));
        double minimumDelta = navigate.getKeyExtractor().apply(minimumPointOptional.get(), mousePos) + 10.0;
        Optional<NavigationPoint> targetPointOptional = targetPoints.stream().filter(point -> navigate.getKeyExtractor().apply((NavigationPoint)point, mousePos) <= minimumDelta).min(Comparator.comparing(p -> p.distanceTo(mouseX, mouseY)));
        if (targetPointOptional.isPresent()) {
            this.performMouseDrag(this.targetMouseX, this.targetMouseY, 0.0, 0.0);
            NavigationPoint targetPoint = targetPointOptional.get();
            int screenX = (int)(targetPoint.getX() / ((double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m()));
            int screenY = (int)(targetPoint.getY() / ((double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n()));
            double lastTargetMouseX = this.targetMouseX;
            double lastTargetMouseY = this.targetMouseY;
            this.targetMouseX = this.prevTargetMouseX = screenX;
            this.targetMouseY = this.prevTargetMouseY = screenY;
            this.setMousePosition(screenX, screenY);
            mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187638_cR, (float)2.0f));
            this.performMouseDrag(this.targetMouseX, this.targetMouseY, (double)screenX - lastTargetMouseX, (double)screenY - lastTargetMouseY);
        }
    }

    private List<NavigationPoint> gatherNavigationPoints(Screen screen) {
        RecipeBookGui recipeBook;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        if (screen instanceof ContainerScreen) {
            ContainerScreen containerScreen = (ContainerScreen)screen;
            int guiLeft = containerScreen.getGuiLeft();
            int n = containerScreen.getGuiTop();
            for (Slot slot : containerScreen.func_212873_a_().field_75151_b) {
                if (containerScreen.getSlotUnderMouse() == slot) continue;
                int posX = guiLeft + slot.field_75223_e + 8;
                int posY = n + slot.field_75221_f + 8;
                points.add(new SlotNavigationPoint((double)posX, (double)posY, slot));
            }
        }
        ArrayList<Object> widgets = new ArrayList<Object>();
        for (IGuiEventListener iGuiEventListener : screen.children()) {
            if (!(iGuiEventListener instanceof Widget)) continue;
            widgets.add((Widget)iGuiEventListener);
        }
        if (screen instanceof IRecipeShownListener && (recipeBook = ((IRecipeShownListener)screen).func_194310_f()).func_191878_b()) {
            widgets.add(((RecipeBookGuiMixin)recipeBook).getToggleRecipesBtn());
            widgets.addAll(((RecipeBookGuiMixin)recipeBook).getRecipeTabs());
            RecipeBookPage recipeBookPage = ((RecipeBookGuiMixin)recipeBook).getRecipeBookPage();
            widgets.addAll(((RecipeBookPageAccessor)recipeBookPage).getButtons());
            widgets.add(((RecipeBookPageAccessor)recipeBookPage).getForwardButton());
            widgets.add(((RecipeBookPageAccessor)recipeBookPage).getBackButton());
        }
        for (Widget widget : widgets) {
            if (widget == null || widget.isHovered() || !widget.visible) continue;
            int posX = widget.x + widget.getWidth() / 2;
            int posY = widget.y + widget.getHeight() / 2;
            points.add(new WidgetNavigationPoint((double)posX, (double)posY, widget));
        }
        if (screen instanceof CreativeScreen) {
            int tabPage = CreativeScreenMixin.getTabPage();
            int n = tabPage * 10;
            int end = Math.min(ItemGroup.field_78032_a.length, (tabPage + 1) * 10 + 2);
            for (int i = n; i < end; ++i) {
                ItemGroup group = ItemGroup.field_78032_a[i];
                if (group == null) continue;
                points.add(this.getCreativeTabPoint((ContainerScreen)((CreativeScreen)screen), group));
            }
        }
        if (Controllable.isJeiLoaded()) {
            points.addAll(JustEnoughItems.getNavigationPoints());
        }
        return points;
    }

    private BasicNavigationPoint getCreativeTabPoint(ContainerScreen screen, ItemGroup group) {
        boolean topRow = group.func_78023_l();
        int column = group.func_78020_k();
        int width = 28;
        int height = 32;
        int x = screen.getGuiLeft() + width * column;
        int y = screen.getGuiTop();
        x = group.func_192394_m() ? screen.getGuiLeft() + screen.getXSize() - width * (6 - column) : (column > 0 ? x + column : x);
        y = topRow ? y - width : y + (screen.getYSize() - 4);
        return new BasicNavigationPoint((double)x + (double)width / 2.0, (double)y + (double)height / 2.0);
    }

    private void craftRecipeBookItem() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (!(mc.field_71462_r instanceof ContainerScreen) || !(mc.field_71462_r instanceof IRecipeShownListener)) {
            return;
        }
        IRecipeShownListener listener = (IRecipeShownListener)mc.field_71462_r;
        if (!listener.func_194310_f().func_191878_b()) {
            return;
        }
        ContainerScreen screen = (ContainerScreen)mc.field_71462_r;
        if (!(screen.func_212873_a_() instanceof RecipeBookContainer)) {
            return;
        }
        RecipeBookPage recipeBookPage = ((RecipeBookGuiMixin)listener.func_194310_f()).getRecipeBookPage();
        RecipeWidget recipe = ((RecipeBookPageAccessor)recipeBookPage).getButtons().stream().filter(Widget::isHovered).findFirst().orElse(null);
        if (recipe != null) {
            RecipeBookContainer container = (RecipeBookContainer)screen.func_212873_a_();
            Slot slot = container.func_75139_a(container.func_201767_f());
            if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.invokeMouseClick((Screen)screen, 0, screen.getGuiLeft() + slot.field_75223_e + 8, screen.getGuiTop() + slot.field_75221_f + 8);
            } else {
                this.invokeMouseReleased((Screen)screen, 0, screen.getGuiLeft() + slot.field_75223_e + 8, screen.getGuiTop() + slot.field_75221_f + 8);
            }
        }
    }

    private void moveMouseToClosestSlot(boolean moving, Screen screen) {
        this.nearSlot = false;
        if (screen instanceof ContainerScreen) {
            if (!this.moved) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            ContainerScreen guiContainer = (ContainerScreen)screen;
            int guiLeft = guiContainer.getGuiLeft();
            int guiTop = guiContainer.getGuiTop();
            int mouseX = (int)((double)this.targetMouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
            int mouseY = (int)((double)this.targetMouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
            Slot closestSlot = null;
            double closestDistance = -1.0;
            for (Slot slot : guiContainer.func_212873_a_().field_75151_b) {
                int posX = guiLeft + slot.field_75223_e + 8;
                int posY = guiTop + slot.field_75221_f + 8;
                double distance = Math.sqrt(Math.pow(posX - mouseX, 2.0) + Math.pow(posY - mouseY, 2.0));
                if (closestDistance != -1.0 && !(distance < closestDistance) || !(distance <= 14.0)) continue;
                closestSlot = slot;
                closestDistance = distance;
            }
            if (closestSlot != null && (closestSlot.func_75216_d() || !mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b())) {
                this.nearSlot = true;
                int slotCenterXScaled = guiLeft + closestSlot.field_75223_e + 8;
                int slotCenterYScaled = guiTop + closestSlot.field_75221_f + 8;
                int slotCenterX = (int)((double)slotCenterXScaled / ((double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m()));
                int slotCenterY = (int)((double)slotCenterYScaled / ((double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n()));
                double deltaX = slotCenterX - this.targetMouseX;
                double deltaY = slotCenterY - this.targetMouseY;
                if (!moving) {
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        this.targetMouseX = (int)((double)this.targetMouseX + deltaX * 0.75);
                        this.targetMouseY = (int)((double)this.targetMouseY + deltaY * 0.75);
                    } else {
                        this.mouseSpeedX = 0.0;
                        this.mouseSpeedY = 0.0;
                    }
                }
                this.mouseSpeedX *= 0.75;
                this.mouseSpeedY *= 0.75;
            } else {
                this.mouseSpeedX = 0.0;
                this.mouseSpeedY = 0.0;
            }
        } else {
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
        }
    }

    private void setMousePosition(double mouseX, double mouseY) {
        if (((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue()) {
            this.virtualMouseX = mouseX;
            this.virtualMouseY = mouseY;
        } else {
            Minecraft mc = Minecraft.func_71410_x();
            GLFW.glfwSetCursorPos((long)mc.func_228018_at_().func_198092_i(), (double)mouseX, (double)mouseY);
            this.preventReset = true;
        }
    }

    private void handleCreativeScrolling(CreativeScreen creative, Controller controller) {
        try {
            int i = (((CreativeScreen.CreativeContainer)creative.func_212873_a_()).field_148330_a.size() + 9 - 1) / 9 - 5;
            int dir = 0;
            if (controller.getRThumbStickYValue() <= -0.8f) {
                dir = 1;
            } else if (controller.getRThumbStickYValue() >= 0.8f) {
                dir = -1;
            }
            Field field = ObfuscationReflectionHelper.findField(CreativeScreen.class, (String)"field_147067_x");
            field.setAccessible(true);
            float currentScroll = field.getFloat(creative);
            currentScroll = (float)((double)currentScroll - (double)dir / (double)i);
            currentScroll = MathHelper.func_76131_a((float)currentScroll, (float)0.0f, (float)1.0f);
            field.setFloat(creative, currentScroll);
            ((CreativeScreen.CreativeContainer)creative.func_212873_a_()).func_148329_a(currentScroll);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void handleListScrolling(AbstractList list, Controller controller) {
        double dir = 0.0;
        if (Math.abs(controller.getRThumbStickYValue()) >= 0.2f) {
            this.setControllerInUse();
            dir = controller.getRThumbStickYValue();
        }
        list.setScrollAmount(list.getScrollAmount() + (dir *= (double)Minecraft.func_71410_x().func_193989_ak()) * 10.0);
    }

    private double getMouseX() {
        Minecraft mc = Minecraft.func_71410_x();
        double mouseX = mc.field_71417_B.func_198024_e();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && this.lastUse > 0) {
            mouseX = this.virtualMouseX;
        }
        return mouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
    }

    private double getMouseY() {
        Minecraft mc = Minecraft.func_71410_x();
        double mouseY = mc.field_71417_B.func_198026_f();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && this.lastUse > 0) {
            mouseY = this.virtualMouseY;
        }
        return mouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
    }

    private void invokeMouseClick(Screen screen, int button) {
        if (screen != null) {
            double mouseX = this.getMouseX();
            double mouseY = this.getMouseY();
            this.invokeMouseClick(screen, button, mouseX, mouseY);
        }
    }

    private void invokeMouseClick(Screen screen, int button, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (screen != null) {
            mc.field_71417_B.field_198042_g = button;
            mc.field_71417_B.field_198045_j = NativeUtil.func_216394_b();
            Screen.wrapScreenError(() -> {
                boolean cancelled = ForgeHooksClient.onGuiMouseClickedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
                if (!cancelled) {
                    cancelled = screen.mouseClicked(mouseX, mouseY, button);
                }
                if (!cancelled) {
                    ForgeHooksClient.onGuiMouseClickedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
                }
            }, (String)"mouseClicked event handler", (String)screen.getClass().getCanonicalName());
        }
    }

    private void invokeMouseReleased(Screen screen, int button) {
        if (screen != null) {
            double mouseX = this.getMouseX();
            double mouseY = this.getMouseY();
            this.invokeMouseReleased(screen, button, mouseX, mouseY);
        }
    }

    private void invokeMouseReleased(Screen screen, int button, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (screen != null) {
            mc.field_71417_B.field_198042_g = -1;
            Screen.wrapScreenError(() -> {
                boolean cancelled = ForgeHooksClient.onGuiMouseReleasedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
                if (!cancelled) {
                    cancelled = screen.mouseReleased(mouseX, mouseY, button);
                }
                if (!cancelled) {
                    ForgeHooksClient.onGuiMouseReleasedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
                }
            }, (String)"mouseReleased event handler", (String)screen.getClass().getCanonicalName());
        }
    }

    private static interface NavigatePredicate {
        public boolean test(NavigationPoint var1, int var2, int var3);
    }

    private static enum Navigate {
        UP((p, x, y) -> p.getY() < (double)y, (p, v) -> Math.abs(p.getX() - v.field_72450_a)),
        DOWN((p, x, y) -> p.getY() > (double)(y + 1), (p, v) -> Math.abs(p.getX() - v.field_72450_a)),
        LEFT((p, x, y) -> p.getX() < (double)x, (p, v) -> Math.abs(p.getY() - v.field_72448_b)),
        RIGHT((p, x, y) -> p.getX() > (double)(x + 1), (p, v) -> Math.abs(p.getY() - v.field_72448_b));

        private NavigatePredicate predicate;
        private BiFunction<? super NavigationPoint, Vec3d, Double> keyExtractor;

        private Navigate(NavigatePredicate predicate, BiFunction<? super NavigationPoint, Vec3d, Double> keyExtractor) {
            this.predicate = predicate;
            this.keyExtractor = keyExtractor;
        }

        public NavigatePredicate getPredicate() {
            return this.predicate;
        }

        public BiFunction<? super NavigationPoint, Vec3d, Double> getKeyExtractor() {
            return this.keyExtractor;
        }

        public Comparator<NavigationPoint> getMinComparator(int mouseX, int mouseY) {
            return Comparator.comparing(p -> this.keyExtractor.apply((NavigationPoint)p, new Vec3d((double)mouseX, (double)mouseY, 0.0)));
        }

        public static void main(String[] args) {
            int slotX = 10;
            int slotY = 20;
            int mouseX = 50;
            int mouseY = 20;
            Navigate.angle(new SlotNavigationPoint((double)slotX, (double)slotY, null), mouseX, mouseY, 0.0);
        }

        private static boolean angle(NavigationPoint point, int mouseX, int mouseY, double offset) {
            double angle = Math.toDegrees(Math.atan2(point.getY() - (double)mouseY, point.getX() - (double)mouseX)) + offset;
            return angle > -45.0 && angle < 45.0;
        }
    }
}

