/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonBindingList
extends AbstractOptionList<Entry> {
    private ButtonBindingScreen screen;
    private Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    public ButtonBindingList(ButtonBindingScreen screen, Minecraft mc, int widthIn, int heightIn, int topIn, int bottomIn, int itemHeightIn) {
        super(mc, widthIn, heightIn, topIn, bottomIn, itemHeightIn);
        this.screen = screen;
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.addEntry((AbstractList.AbstractListEntry)new CategoryEntry((ITextComponent)new TranslationTextComponent(category, new Object[0])));
                list.forEach(binding -> this.addEntry((AbstractList.AbstractListEntry)new BindingEntry((ButtonBinding)binding)));
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.screen.isWaitingForButtonInput()) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected class BindingEntry
    extends Entry {
        private ButtonBinding binding;
        private TextComponent label;
        private ButtonBindingButton bindingButton;
        private ImageButton deleteButton;

        protected BindingEntry(ButtonBinding binding) {
            this.binding = binding;
            this.label = new TranslationTextComponent(binding.getDescription(), new Object[0]);
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> ButtonBindingList.this.screen.setSelectedBinding(this.binding));
            this.deleteButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                binding.reset();
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.resetBindingHash();
                registry.save();
            });
        }

        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.bindingButton), (Object)((Object)this.deleteButton));
        }

        public void render(int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            int color = this.binding.isConflictingContext() ? TextFormatting.RED.func_211163_e() : TextFormatting.GRAY.func_211163_e();
            ((ButtonBindingList)ButtonBindingList.this).minecraft.field_71466_p.func_211126_b(this.label.func_150254_d(), (float)(left - 15), (float)(y + 6), color);
            this.bindingButton.x = left + width - 45;
            this.bindingButton.y = y;
            this.bindingButton.render(mouseX, mouseY, partialTicks);
            this.deleteButton.x = left + width - 20;
            this.deleteButton.y = y;
            this.deleteButton.active = !this.binding.isDefault();
            this.deleteButton.render(mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 1 && this.bindingButton.isHovered()) {
                this.binding.setButton(-1);
                this.bindingButton.playDownSound(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    protected class CategoryEntry
    extends Entry {
        private final ITextComponent label;
        private final int labelWidth;

        protected CategoryEntry(ITextComponent label) {
            this.label = label;
            this.labelWidth = ((ButtonBindingList)ButtonBindingList.this).minecraft.field_71466_p.func_78256_a(this.label.func_150254_d());
        }

        public boolean changeFocus(boolean focus) {
            return false;
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.emptyList();
        }

        public void render(int x, int y, int p_230432_4_, int p_230432_5_, int itemHeight, int p_230432_7_, int p_230432_8_, boolean selected, float partialTicks) {
            float labelX = (float)((ButtonBindingList)ButtonBindingList.this).minecraft.field_71462_r.width / 2.0f - (float)this.labelWidth / 2.0f;
            float labelY = y + itemHeight - 9 - 1;
            ((ButtonBindingList)ButtonBindingList.this).minecraft.field_71466_p.func_211126_b(this.label.func_150254_d(), labelX, labelY, -1);
        }
    }

    abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        Entry() {
        }
    }
}

