/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonBindingScreen
extends Screen {
    private Screen parentScreen;
    private Button buttonReset;
    private ButtonBindingList bindingList;
    private ButtonBinding selectedBinding = null;

    protected ButtonBindingScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("controllable.gui.title.button_binding", new Object[0]));
        this.parentScreen = parentScreen;
    }

    void setSelectedBinding(ButtonBinding selectedBinding) {
        this.selectedBinding = selectedBinding;
    }

    boolean isWaitingForButtonInput() {
        return this.selectedBinding != null;
    }

    protected void init() {
        this.bindingList = new ButtonBindingList(this, this.minecraft, this.width + 10, this.height, 32, this.height - 44, 20);
        this.children.add(this.bindingList);
        this.buttonReset = (Button)this.addButton((Widget)new Button(this.width / 2 - 155, this.height - 29, 150, 20, I18n.func_135052_a((String)"controllable.gui.resetBinds", (Object[])new Object[0]), button -> {
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.getBindings().forEach(ButtonBinding::reset);
            registry.resetBindingHash();
            registry.save();
        }));
        this.buttonReset.active = BindingRegistry.getInstance().getBindings().stream().noneMatch(ButtonBinding::isDefault);
        this.addButton((Widget)new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            this.minecraft.func_147108_a(this.parentScreen);
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
        }));
    }

    public void tick() {
        this.buttonReset.active = !BindingRegistry.getInstance().getBindings().stream().allMatch(ButtonBinding::isDefault);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.bindingList.render(this.selectedBinding == null ? mouseX : -1, this.selectedBinding == null ? mouseY : -1, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        super.render(this.selectedBinding == null ? mouseX : -1, this.selectedBinding == null ? mouseY : -1, partialTicks);
        if (this.selectedBinding != null) {
            RenderSystem.disableDepthTest();
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
            this.drawCenteredString(this.font, new TranslationTextComponent("controllable.gui.layout.press_button", new Object[0]).func_150254_d(), this.width / 2, this.height / 2, -1);
            RenderSystem.enableDepthTest();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.selectedBinding != null) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int key, int scanCode, int mods) {
        if (key == 256 && this.selectedBinding != null) {
            this.selectedBinding = null;
            return true;
        }
        return super.keyPressed(key, scanCode, mods);
    }

    public boolean processButton(int index) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setButton(index);
            this.selectedBinding = null;
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
            return true;
        }
        return false;
    }
}

